/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.test.TestDeployer;
import org.jboss.wsf.test.TestDeployerJBoss;

public class JBossWSTestHelper {
    private static final String SYSPROP_JBOSSWS_INTEGRATION_TARGET = "jbossws.integration.target";
    private static final String SYSPROP_JBOSS_BIND_ADDRESS = "jboss.bind.address";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final boolean DEPLOY_PROCESS_ENABLED = !Boolean.getBoolean("test.disable.deployment");
    private static MBeanServerConnection server;
    private static String integrationTarget;
    private static String implVendor;
    private static String implTitle;
    private static String implVersion;
    private static String testArchiveDir;
    private static String testResourcesDir;

    public static void deploy(String archive) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            URL archiveURL = JBossWSTestHelper.getArchiveFile(archive).toURL();
            JBossWSTestHelper.getDeployer().deploy(archiveURL);
        }
    }

    public static void undeploy(String archive) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            URL archiveURL = JBossWSTestHelper.getArchiveFile(archive).toURL();
            JBossWSTestHelper.getDeployer().undeploy(archiveURL);
        }
    }

    public static boolean isTargetJBoss5() {
        return JBossWSTestHelper.isTargetJBoss52() || JBossWSTestHelper.isTargetJBoss51() || JBossWSTestHelper.isTargetJBoss50();
    }

    public static boolean isTargetJBoss50() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("jboss50");
    }

    public static boolean isTargetJBoss51() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("jboss51");
    }

    public static boolean isTargetJBoss52() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("jboss52");
    }

    public static boolean isTargetJBoss6() {
        return JBossWSTestHelper.isTargetJBoss61() || JBossWSTestHelper.isTargetJBoss60();
    }

    public static boolean isTargetJBoss60() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("jboss60");
    }

    public static boolean isTargetJBoss61() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("jboss61");
    }

    public static boolean isIntegrationNative() {
        String vendor = JBossWSTestHelper.getImplementationVendor();
        return vendor.toLowerCase().indexOf("jboss") != -1;
    }

    public static boolean isIntegrationMetro() {
        String vendor = JBossWSTestHelper.getImplementationVendor();
        return vendor.toLowerCase().indexOf("sun") != -1;
    }

    public static boolean isIntegrationCXF() {
        String vendor = JBossWSTestHelper.getImplementationVendor();
        return vendor.toLowerCase().indexOf("apache") != -1;
    }

    private static String getImplementationVendor() {
        if (implVendor == null) {
            Object obj = JBossWSTestHelper.getImplementationObject();
            implVendor = obj.getClass().getPackage().getImplementationVendor();
            if (implVendor == null) {
                implVendor = JBossWSTestHelper.getImplementationPackage();
            }
            implTitle = obj.getClass().getPackage().getImplementationTitle();
            implVersion = obj.getClass().getPackage().getImplementationVersion();
            System.out.println(implVendor + ", " + implTitle + ", " + implVersion);
        }
        return implVendor;
    }

    private static Object getImplementationObject() {
        Service service = Service.create((QName)new QName("dummyService"));
        HandlerResolver obj = service.getHandlerResolver();
        if (obj == null) {
            service.addPort(new QName("dummyPort"), "http://schemas.xmlsoap.org/wsdl/soap/http", "http://dummy-address");
            obj = service.createDispatch(new QName("dummyPort"), Source.class, Service.Mode.PAYLOAD);
        }
        return obj;
    }

    private static String getImplementationPackage() {
        return JBossWSTestHelper.getImplementationObject().getClass().getPackage().getName();
    }

    public static String getServerHost() {
        return System.getProperty(SYSPROP_JBOSS_BIND_ADDRESS, "localhost");
    }

    public static MBeanServerConnection getServer() {
        if (server == null) {
            Hashtable<?, ?> jndiEnv = null;
            try {
                InitialContext iniCtx = new InitialContext();
                jndiEnv = iniCtx.getEnvironment();
                server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException ex) {
                throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
            }
        }
        return server;
    }

    private static TestDeployer getDeployer() {
        return new TestDeployerJBoss(JBossWSTestHelper.getServer());
    }

    public static String getIntegrationTarget() {
        if (integrationTarget == null) {
            String jbossVersion;
            block11: {
                integrationTarget = System.getProperty(SYSPROP_JBOSSWS_INTEGRATION_TARGET);
                if (integrationTarget == null) {
                    throw new IllegalStateException("Cannot obtain system property: jbossws.integration.target");
                }
                jbossVersion = null;
                try {
                    ObjectName oname = ObjectNameFactory.create("jboss.system:type=Server");
                    jbossVersion = (String)JBossWSTestHelper.getServer().getAttribute(oname, "VersionNumber");
                    if (jbossVersion == null) {
                        throw new IllegalStateException("Cannot obtain jboss version");
                    }
                    if (jbossVersion.startsWith("5.2")) {
                        jbossVersion = "jboss52";
                        break block11;
                    }
                    if (jbossVersion.startsWith("5.1")) {
                        jbossVersion = "jboss51";
                        break block11;
                    }
                    if (jbossVersion.startsWith("5.0")) {
                        jbossVersion = "jboss50";
                        break block11;
                    }
                    if (jbossVersion.startsWith("6.1")) {
                        jbossVersion = "jboss61";
                        break block11;
                    }
                    if (jbossVersion.startsWith("6.0")) {
                        jbossVersion = "jboss60";
                        break block11;
                    }
                    throw new IllegalStateException("Unsupported jboss version: " + jbossVersion);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (!integrationTarget.startsWith(jbossVersion)) {
                throw new IllegalStateException("Integration target mismatch: " + integrationTarget + ".startsWith(" + jbossVersion + ")");
            }
        }
        return integrationTarget;
    }

    public static URL getArchiveURL(String archive) throws MalformedURLException {
        return JBossWSTestHelper.getArchiveFile(archive).toURL();
    }

    public static File getArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestArchiveDir() + "/" + archive);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestArchiveDir() == null ? " System property 'test.archive.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestArchiveDir() + "/" + archive + "'." + notSet);
    }

    public static URL getResourceURL(String resource) throws MalformedURLException {
        return JBossWSTestHelper.getResourceFile(resource).toURL();
    }

    public static File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestResourcesDir() + "/" + resource);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestResourcesDir() == null ? " System property 'test.resources.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestResourcesDir() + "/" + resource + "'." + notSet);
    }

    public static String getTestArchiveDir() {
        if (testArchiveDir == null) {
            testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY);
        }
        return testArchiveDir;
    }

    public static String getTestResourcesDir() {
        if (testResourcesDir == null) {
            testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY);
        }
        return testResourcesDir;
    }
}

