/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.serviceref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.jws.HandlerChain;
import javax.naming.Referenceable;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.MTOM;
import org.jboss.wsf.common.serviceref.AbstractServiceRefBinder;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public abstract class AbstractServiceRefBinderJAXWS
extends AbstractServiceRefBinder {
    @Override
    public final Referenceable createReferenceable(UnifiedServiceRefMetaData serviceRef, ClassLoader loader) {
        this.processAddressingAnnotation(serviceRef);
        this.processMTOMAnnotation(serviceRef);
        this.processRespectBindingAnnotation(serviceRef);
        this.processHandlerChainAnnotation(serviceRef);
        WebServiceRef serviceRefAnnotation = this.getWebServiceRefAnnotation(serviceRef);
        Class<?> targetClass = this.getTargetClass(serviceRef, serviceRefAnnotation);
        String targetClassName = targetClass != null ? targetClass.getName() : null;
        String serviceImplClassName = this.getServiceImplClassName(serviceRef, serviceRefAnnotation, targetClass);
        this.processWsdlOverride(serviceRef, serviceRefAnnotation, loader, serviceImplClassName);
        return this.createJAXWSReferenceable(serviceImplClassName, targetClassName, serviceRef);
    }

    protected abstract Referenceable createJAXWSReferenceable(String var1, String var2, UnifiedServiceRefMetaData var3);

    private void processAddressingAnnotation(UnifiedServiceRefMetaData serviceRefMD) {
        Addressing addressingAnnotation = this.getAnnotation(serviceRefMD, Addressing.class);
        if (addressingAnnotation != null) {
            serviceRefMD.setAddressingEnabled(addressingAnnotation.enabled());
            serviceRefMD.setAddressingRequired(addressingAnnotation.required());
            serviceRefMD.setAddressingResponses(addressingAnnotation.responses().toString());
        }
    }

    private void processMTOMAnnotation(UnifiedServiceRefMetaData serviceRefMD) {
        MTOM mtomAnnotation = this.getAnnotation(serviceRefMD, MTOM.class);
        if (mtomAnnotation != null) {
            serviceRefMD.setMtomEnabled(mtomAnnotation.enabled());
            serviceRefMD.setMtomThreshold(mtomAnnotation.threshold());
        }
    }

    private void processRespectBindingAnnotation(UnifiedServiceRefMetaData serviceRefMD) {
        RespectBinding respectBindingAnnotation = this.getAnnotation(serviceRefMD, RespectBinding.class);
        if (respectBindingAnnotation != null) {
            serviceRefMD.setRespectBindingEnabled(respectBindingAnnotation.enabled());
        }
    }

    private void processHandlerChainAnnotation(UnifiedServiceRefMetaData serviceRefMD) {
        HandlerChain handlerChainAnnotation = this.getAnnotation(serviceRefMD, HandlerChain.class);
        if (handlerChainAnnotation != null) {
            String handlerChain = serviceRefMD.getHandlerChain();
            if (handlerChain == null && handlerChainAnnotation.file().length() > 0) {
                handlerChain = handlerChainAnnotation.file();
            }
            if (handlerChain != null) {
                try {
                    new URL(handlerChain);
                }
                catch (MalformedURLException ignored) {
                    AnnotatedElement annotatedElement = (AnnotatedElement)serviceRefMD.getAnnotatedElement();
                    Class<?> declaringClass = this.getDeclaringClass(annotatedElement);
                    handlerChain = declaringClass.getPackage().getName().replace('.', '/') + "/" + handlerChain;
                }
                serviceRefMD.setHandlerChain(handlerChain);
            }
        }
    }

    private <T extends Annotation> T getAnnotation(UnifiedServiceRefMetaData serviceRefMD, Class<T> annotationClass) {
        AnnotatedElement annotatedElement = (AnnotatedElement)serviceRefMD.getAnnotatedElement();
        return annotatedElement != null ? (T)annotatedElement.getAnnotation(annotationClass) : null;
    }

    private void processWsdlOverride(UnifiedServiceRefMetaData serviceRefMD, WebServiceRef serviceRefAnnotation, ClassLoader loader, String serviceImplClassName) {
        if (serviceRefMD.getWsdlOverride() == null && serviceRefAnnotation != null && serviceRefAnnotation.wsdlLocation().length() > 0) {
            serviceRefMD.setWsdlOverride(serviceRefAnnotation.wsdlLocation());
        }
        if (null == serviceRefMD.getServiceQName()) {
            try {
                Class<?> serviceClass = loader.loadClass(serviceImplClassName);
                if (serviceClass.getAnnotation(WebServiceClient.class) != null) {
                    WebServiceClient clientDecl = serviceClass.getAnnotation(WebServiceClient.class);
                    serviceRefMD.setServiceQName(new QName(clientDecl.targetNamespace(), clientDecl.name()));
                    if (clientDecl.wsdlLocation().length() > 0 && serviceRefMD.getWsdlLocation() == null) {
                        serviceRefMD.setWsdlOverride(clientDecl.wsdlLocation());
                    }
                }
            }
            catch (ClassNotFoundException e) {
                WSFException.rethrow((String)"Cannot extract service QName for target service", (Throwable)e);
            }
        }
    }

    private Class<?> getDeclaringClass(AnnotatedElement annotatedElement) {
        Class declaringClass = null;
        if (annotatedElement instanceof Field) {
            declaringClass = ((Field)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Method) {
            declaringClass = ((Method)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Class) {
            declaringClass = (Class)annotatedElement;
        }
        return declaringClass;
    }

    private Class<?> getTargetClass(UnifiedServiceRefMetaData serviceRefMD, WebServiceRef serviceRefAnnotation) {
        AnnotatedElement annotatedElement = (AnnotatedElement)serviceRefMD.getAnnotatedElement();
        Class targetClass = null;
        if (annotatedElement instanceof Field) {
            targetClass = ((Field)annotatedElement).getType();
        } else if (annotatedElement instanceof Method) {
            targetClass = ((Method)annotatedElement).getParameterTypes()[0];
        } else if (serviceRefAnnotation != null && serviceRefAnnotation.type() != Object.class) {
            targetClass = serviceRefAnnotation.type();
        }
        return targetClass;
    }

    private WebServiceRef getWebServiceRefAnnotation(UnifiedServiceRefMetaData serviceRefMD) {
        WebServiceRef webServiceRefAnnotation = this.getAnnotation(serviceRefMD, WebServiceRef.class);
        WebServiceRefs webServiceRefsAnnotation = this.getAnnotation(serviceRefMD, WebServiceRefs.class);
        if (webServiceRefAnnotation == null && webServiceRefsAnnotation == null) {
            return null;
        }
        ArrayList<WebServiceRef> wsrefList = new ArrayList<WebServiceRef>();
        if (webServiceRefAnnotation != null) {
            wsrefList.add(webServiceRefAnnotation);
        }
        if (webServiceRefsAnnotation != null) {
            for (WebServiceRef webServiceRefAnn : webServiceRefsAnnotation.value()) {
                wsrefList.add(webServiceRefAnn);
            }
        }
        WebServiceRef returnValue = null;
        if (wsrefList.size() == 1) {
            returnValue = (WebServiceRef)wsrefList.get(0);
        } else {
            for (WebServiceRef webServiceRefAnn : wsrefList) {
                if (!serviceRefMD.getServiceRefName().endsWith(webServiceRefAnn.name())) continue;
                returnValue = webServiceRefAnn;
                break;
            }
        }
        return returnValue;
    }

    private String getServiceImplClassName(UnifiedServiceRefMetaData serviceRefMD, WebServiceRef serviceRefAnnotation, Class<?> targetClass) {
        String serviceImplClass = null;
        if (serviceRefAnnotation != null && serviceRefAnnotation.value() != Service.class) {
            serviceImplClass = serviceRefAnnotation.value().getName();
        }
        if (serviceImplClass == null && targetClass != null && Service.class.isAssignableFrom(targetClass)) {
            serviceImplClass = targetClass.getName();
        }
        if (serviceImplClass == null && serviceRefMD.getServiceInterface() != null) {
            serviceImplClass = serviceRefMD.getServiceInterface();
        }
        if (serviceImplClass == null) {
            serviceImplClass = Service.class.getName();
        }
        return serviceImplClass;
    }
}

