/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.invocation;

import java.lang.reflect.Method;
import org.jboss.wsf.common.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;

public abstract class AbstractInvocationHandlerJSE
extends AbstractInvocationHandler {
    protected AbstractInvocationHandlerJSE() {
    }

    protected final Object getTargetBean(Endpoint endpoint, Invocation invocation) throws Exception {
        InvocationContext invocationContext = invocation.getInvocationContext();
        Object targetBean = invocationContext.getTargetBean();
        if (targetBean == null) {
            try {
                Class endpointImplClass = endpoint.getTargetBeanClass();
                targetBean = endpointImplClass.newInstance();
                invocationContext.setTargetBean(targetBean);
                this.onEndpointInstantiated(endpoint, invocation);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot create endpoint instance: ", ex);
            }
        }
        return targetBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(Endpoint endpoint, Invocation invocation) throws Exception {
        try {
            Object targetBean = this.getTargetBean(endpoint, invocation);
            Class<?> implClass = targetBean.getClass();
            Method seiMethod = invocation.getJavaMethod();
            Method implMethod = this.getImplMethod(implClass, seiMethod);
            Object[] args = invocation.getArgs();
            this.onBeforeInvocation(invocation);
            Object retObj = implMethod.invoke(targetBean, args);
            invocation.setReturnValue(retObj);
        }
        catch (Exception e) {
            this.log.error((Object)("Method invocation failed with exception: " + e.getMessage()), (Throwable)e);
            this.handleInvocationException(e);
        }
        finally {
            this.onAfterInvocation(invocation);
        }
    }
}

