/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.invocation;

import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.wsf.common.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;

public abstract class AbstractInvocationHandlerJSE
extends AbstractInvocationHandler {
    private static final String POJO_JNDI_PREFIX = "java:comp/env/";
    private boolean initialized;

    protected AbstractInvocationHandlerJSE() {
    }

    protected final synchronized Object getTargetBean(Endpoint endpoint, Invocation invocation) throws Exception {
        InvocationContext invocationContext = invocation.getInvocationContext();
        Object targetBean = invocationContext.getTargetBean();
        if (targetBean == null) {
            try {
                Class endpointImplClass = endpoint.getTargetBeanClass();
                targetBean = endpointImplClass.newInstance();
                invocationContext.setTargetBean(targetBean);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot create endpoint instance: ", ex);
            }
        }
        if (!this.initialized) {
            this.onEndpointInstantiated(endpoint, invocation);
            this.initialized = true;
        }
        return targetBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(Endpoint endpoint, Invocation invocation) throws Exception {
        try {
            Object targetBean = this.getTargetBean(endpoint, invocation);
            Class<?> implClass = targetBean.getClass();
            Method seiMethod = invocation.getJavaMethod();
            Method implMethod = this.getImplMethod(implClass, seiMethod);
            Object[] args = invocation.getArgs();
            this.onBeforeInvocation(invocation);
            Object retObj = implMethod.invoke(targetBean, args);
            invocation.setReturnValue(retObj);
        }
        catch (Exception e) {
            this.log.error((Object)("Method invocation failed with exception: " + e.getMessage()), (Throwable)e);
            this.handleInvocationException(e);
        }
        finally {
            this.onAfterInvocation(invocation);
        }
    }

    @Override
    public Context getJNDIContext(Endpoint ep) throws NamingException {
        return (Context)new InitialContext().lookup(POJO_JNDI_PREFIX);
    }
}

