/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;

public class EndpointRegistryDeploymentAspect
extends AbstractDeploymentAspect {
    private EndpointRegistry registry;

    @Override
    public void start(Deployment dep) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        if (this.registry == null) {
            this.registry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            this.registry.register(ep);
        }
    }

    @Override
    public void stop(Deployment dep) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        if (this.registry == null) {
            this.registry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            this.registry.unregister(ep);
        }
    }
}

