/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.logging;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.jboss.logging.Logger;

public class JDKLogHandler
extends Handler {
    public JDKLogHandler() {
        super.setFormatter(new SimpleFormatter());
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            Logger logger = this.getJBossLogger(record);
            Level level = record.getLevel();
            Throwable th = record.getThrown();
            if (level == Level.FINER || level == Level.FINEST) {
                String msg = this.getMessage(record);
                logger.trace((Object)msg, th);
            } else if (level == Level.FINE) {
                String msg = this.getMessage(record);
                logger.debug((Object)msg, th);
            } else if (level == Level.INFO || level == Level.CONFIG || level == Level.ALL) {
                String msg = this.getMessage(record);
                logger.info((Object)msg, th);
            } else if (level == Level.WARNING) {
                String msg = this.getMessage(record);
                logger.warn((Object)msg, th);
            } else if (level == Level.SEVERE) {
                String msg = this.getMessage(record);
                logger.error((Object)msg, th);
            } else if (level == Level.OFF) {
                // empty if block
            }
        }
    }

    private Logger getJBossLogger(LogRecord record) {
        return Logger.getLogger((String)record.getLoggerName());
    }

    private String getMessage(LogRecord record) {
        String msg = null;
        try {
            msg = this.getFormatter().formatMessage(record);
        }
        catch (Exception ex) {
            this.reportError("Cannot obtain message from log record", ex, 5);
        }
        return msg;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        Logger logger = this.getJBossLogger(record);
        Level level = record.getLevel();
        boolean isLoggable = false;
        if (level == Level.FINER || level == Level.FINEST) {
            isLoggable = logger.isTraceEnabled();
        } else if (level == Level.FINE) {
            isLoggable = logger.isDebugEnabled();
        } else if (level == Level.INFO || level == Level.CONFIG) {
            isLoggable = logger.isInfoEnabled();
        } else if (level == Level.SEVERE || level == Level.WARNING || level == Level.ALL) {
            isLoggable = true;
        }
        return isLoggable;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

