/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import org.jboss.ws.Constants;
import org.jboss.ws.api.annotation.AuthMethod;
import org.jboss.ws.api.annotation.TransportGuarantee;
import org.jboss.ws.api.annotation.WebContext;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;

public class ContextRootDeploymentAspect
extends AbstractDeploymentAspect {
    @Override
    public void start(Deployment dep) {
        String contextRoot = dep.getService().getContextRoot();
        if (contextRoot == null) {
            contextRoot = this.getExplicitContextRoot(dep);
            if (contextRoot == null) {
                contextRoot = this.getImplicitContextRoot((ArchiveDeployment)dep);
            }
            if (!contextRoot.startsWith("/")) {
                contextRoot = "/" + contextRoot;
            }
            dep.getService().setContextRoot(contextRoot);
        }
    }

    protected String getExplicitContextRoot(Deployment dep) {
        String contextRoot = null;
        JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
        if (webMetaData != null) {
            contextRoot = webMetaData.getContextRoot();
        }
        if (contextRoot == null) {
            for (Endpoint ep : dep.getService().getEndpoints()) {
                Class implClass = ep.getTargetBeanClass();
                WebContext anWebContext = implClass.getAnnotation(WebContext.class);
                this.validateSecuritySettings(anWebContext);
                if (anWebContext == null || anWebContext.contextRoot().length() <= 0) continue;
                if (contextRoot != null && !contextRoot.equals(anWebContext.contextRoot())) {
                    throw new IllegalStateException("Context root must be the same for all deployed endpoints");
                }
                contextRoot = anWebContext.contextRoot();
            }
        }
        EJBArchiveMetaData appMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
        if (contextRoot == null && appMetaData != null) {
            contextRoot = appMetaData.getWebServiceContextRoot();
        }
        return contextRoot;
    }

    protected String getImplicitContextRoot(ArchiveDeployment dep) {
        String simpleName = dep.getSimpleName();
        String contextRoot = simpleName.substring(0, simpleName.length() - 4);
        if (dep.getParent() != null && Constants.BC_CONTEXT_MODE) {
            simpleName = dep.getParent().getSimpleName();
            contextRoot = simpleName.substring(0, simpleName.length() - 4) + "-" + contextRoot;
        }
        return contextRoot;
    }

    private void validateSecuritySettings(WebContext webCtx) {
        if (webCtx != null) {
            TransportGuarantee.valueOf((String)webCtx.transportGuarantee());
            AuthMethod.valueOf((String)webCtx.authMethod());
        }
    }
}

