/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.ws.common.management.DefaultEndpointRegistry;
import org.jboss.ws.common.management.ManagedEndpoint;
import org.jboss.ws.common.management.ManagedEndpointRegistryMBean;
import org.jboss.wsf.spi.deployment.Endpoint;

public class ManagedEndpointRegistry
extends DefaultEndpointRegistry
implements ManagedEndpointRegistryMBean {
    private static final Logger log = Logger.getLogger(ManagedEndpointRegistry.class);
    private MBeanServer mbeanServer;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @Override
    public void register(Endpoint endpoint) {
        super.register(endpoint);
        try {
            ManagedEndpoint jmxEndpoint = new ManagedEndpoint(endpoint, this.mbeanServer);
            this.getMbeanServer().registerMBean(jmxEndpoint, endpoint.getName());
        }
        catch (Exception ex) {
            log.error((Object)"Cannot register endpoint with JMX server", (Throwable)ex);
        }
    }

    @Override
    public void unregister(Endpoint endpoint) {
        super.unregister(endpoint);
        try {
            if (this.getMbeanServer() != null) {
                this.getMbeanServer().unregisterMBean(endpoint.getName());
            } else {
                log.warn((Object)"MBeanServer not available, cannot unregister endpoint with JMX server");
            }
        }
        catch (JMException ex) {
            log.error((Object)"Cannot unregister endpoint with JMX server", (Throwable)ex);
        }
    }

    public void create() throws Exception {
        if (this.mbeanServer != null) {
            this.getMbeanServer().registerMBean(this, OBJECT_NAME);
        }
    }

    public void destroy() throws Exception {
        log.debug((Object)"Destroy service endpoint manager");
        if (this.mbeanServer != null) {
            this.getMbeanServer().unregisterMBean(OBJECT_NAME);
        }
    }
}

