/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.utils;

import java.util.HashMap;

public class XMLPredefinedEntityReferenceResolver {
    private static HashMap<String, Character> entities = new HashMap();

    private static int resolveCharRef(String source, int pos, StringBuilder builder) {
        int end;
        int radix = 10;
        if (source.charAt(pos += 2) == 'x') {
            ++pos;
            radix = 16;
        }
        if ((end = source.indexOf(59, pos)) == -1) {
            throw new IllegalArgumentException("Invalid character reference");
        }
        int c = Integer.parseInt(source.substring(pos, end), radix);
        builder.append((char)c);
        return end + 1;
    }

    private static int resolveEntityRef(String source, int pos, StringBuilder builder) {
        int end;
        if ((end = source.indexOf(59, ++pos)) == -1) {
            throw new IllegalArgumentException("Invalid entity reference");
        }
        String entity = source.substring(pos, end);
        Character c = entities.get(entity);
        if (c == null) {
            throw new IllegalArgumentException("Invalid entity: " + entity);
        }
        builder.append(c.charValue());
        return end + 1;
    }

    public static String resolve(String normalized) {
        String sub;
        StringBuilder builder = new StringBuilder();
        int end = normalized.length();
        int pos = normalized.indexOf(38);
        int last = 0;
        if (pos == -1) {
            return normalized;
        }
        while (pos != -1) {
            sub = ((Object)normalized.subSequence(last, pos)).toString();
            builder.append(sub);
            int peek = pos + 1;
            if (peek == end) {
                throw new IllegalArgumentException("Invalid entity reference");
            }
            pos = normalized.charAt(peek) == '#' ? XMLPredefinedEntityReferenceResolver.resolveCharRef(normalized, pos, builder) : XMLPredefinedEntityReferenceResolver.resolveEntityRef(normalized, pos, builder);
            last = pos;
            pos = normalized.indexOf(38, pos);
        }
        if (last < end) {
            sub = ((Object)normalized.subSequence(last, end)).toString();
            builder.append(sub);
        }
        return builder.toString();
    }

    static {
        entities.put("quot", Character.valueOf('\"'));
        entities.put("amp", Character.valueOf('&'));
        entities.put("lt", Character.valueOf('<'));
        entities.put("gt", Character.valueOf('>'));
        entities.put("apos", Character.valueOf('\''));
    }
}

