/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection.finders;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.injection.InjectionException;
import org.jboss.ws.common.injection.finders.ReflectionUtils;
import org.jboss.ws.common.reflection.MethodFinder;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;

public final class InjectionMethodFinder
extends MethodFinder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(InjectionMethodFinder.class);
    private final InjectionMetaData injectionMD;

    public InjectionMethodFinder(InjectionMetaData injectionMD) {
        if (injectionMD == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INJECTION_METADATA_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        this.injectionMD = injectionMD;
    }

    @Override
    public boolean matches(Method method) {
        String targetName = this.injectionMD.getTargetName();
        String methodName = "set" + targetName.substring(0, 1).toUpperCase() + targetName.substring(1);
        if (method.getName().equals(methodName)) {
            if (this.injectionMD.getValueClass() != null) {
                if (method.getParameterTypes().length == 1) {
                    Class expectedClass = this.injectionMD.getValueClass();
                    Class<?> parameterClass = method.getParameterTypes()[0];
                    return expectedClass.equals(parameterClass);
                }
            } else if (method.getParameterTypes().length == 1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void validate(Collection<Method> methods) {
        super.validate(methods);
        if (methods.size() > 2) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MORE_THAN_ONE_METHOD_FOUND_MATCHING_THE_CRITERIA", (Object[])new Object[]{this.injectionMD}));
        }
    }

    @Override
    public void validate(Method method) {
        super.validate(method);
        ReflectionUtils.assertVoidReturnType(method);
        ReflectionUtils.assertOneParameter(method);
        ReflectionUtils.assertNoPrimitiveParameters(method);
        ReflectionUtils.assertValidSetterName(method);
        ReflectionUtils.assertNoCheckedExceptionsAreThrown(method);
        ReflectionUtils.assertNotStatic(method);
    }
}

