/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.ws.common.utils.ResourceURL;
import org.jboss.ws.common.utils.SecurityActions;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBossWSEntityResolver
extends JBossEntityResolver {
    private static Map<ClassLoader, Map<String, Properties>> propertiesMap = Collections.synchronizedMap(new WeakHashMap());
    private static final Logger log = Logger.getLogger(JBossWSEntityResolver.class);

    public JBossWSEntityResolver() {
        this("META-INF/jbossws-entities.properties");
    }

    public JBossWSEntityResolver(String entitiesResource) {
        Properties props = null;
        ClassLoader loader = SecurityActions.getContextClassLoader();
        Map<String, Properties> map = propertiesMap.get(loader);
        if (map != null && map.containsKey(entitiesResource)) {
            props = map.get(entitiesResource);
        } else {
            if (map == null) {
                map = new ConcurrentHashMap<String, Properties>();
                propertiesMap.put(loader, map);
            }
            if ((props = this.loadEntitiesMappingFromClasspath(entitiesResource, loader)).size() == 0) {
                throw new IllegalArgumentException("No entities mapping defined in resource file: " + entitiesResource);
            }
            map.put(entitiesResource, props);
        }
        String key = null;
        String val = null;
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            val = props.getProperty(key);
            JBossWSEntityResolver.registerEntity((String)key, (String)val);
        }
    }

    private Properties loadEntitiesMappingFromClasspath(final String entitiesResource, final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Properties run() {
                ClassLoader intCl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
                InputStream is = new DelegateClassLoader(intCl, classLoader).getResourceAsStream(entitiesResource);
                if (is == null) {
                    throw new IllegalArgumentException("Resource " + entitiesResource + " not found");
                }
                Properties props = new Properties();
                try {
                    props.load(is);
                }
                catch (IOException ioe) {
                    log.error((Object)("Cannot read resource: " + entitiesResource), (Throwable)ioe);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
                return props;
            }
        });
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (log.isTraceEnabled()) {
            log.trace((Object)("resolveEntity: [pub=" + publicId + ",sysid=" + systemId + "]"));
        }
        if ((inputSource = super.resolveEntity(publicId, systemId)) == null) {
            inputSource = this.resolveSystemIDAsURL(systemId, log.isTraceEnabled());
        }
        if (inputSource == null && log.isDebugEnabled()) {
            log.debug((Object)("Cannot resolve entity: [pub=" + publicId + ",sysid=" + systemId + "]"));
        }
        return inputSource;
    }

    protected InputSource resolveSystemIDAsURL(String id, boolean trace) {
        InputSource inputSource;
        block11: {
            if (id == null) {
                return null;
            }
            if (trace) {
                log.trace((Object)("resolveIDAsResourceURL, id=" + id));
            }
            inputSource = null;
            try {
                InputStream ins;
                URL url;
                if (trace) {
                    log.trace((Object)"Trying to resolve id as a URL");
                }
                if (!(url = new URL(id)).getProtocol().equalsIgnoreCase("file")) {
                    log.warn((Object)("Trying to resolve id as a non-file URL: " + id));
                }
                if ((ins = new ResourceURL(url).openStream()) != null) {
                    inputSource = new InputSource(ins);
                    inputSource.setSystemId(id);
                } else {
                    log.warn((Object)("Cannot load id as URL: " + id));
                }
                if (trace) {
                    log.trace((Object)"Resolved id as a URL");
                }
            }
            catch (MalformedURLException ignored) {
                if (trace) {
                    log.trace((Object)("id is not a url: " + id), (Throwable)ignored);
                }
            }
            catch (IOException e) {
                if (!trace) break block11;
                log.trace((Object)("Failed to obtain URL.InputStream from id: " + id), (Throwable)e);
            }
        }
        return inputSource;
    }
}

