/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.HttpEndpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class EndpointAPIDeploymentAspect
extends AbstractDeploymentAspect {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointAPIDeploymentAspect.class);

    @Override
    public void start(Deployment dep) {
        ClassLoader rtcl;
        ArchiveDeployment arc;
        UnifiedVirtualFile rootFile;
        dep.setType(Deployment.DeploymentType.JAXWS_JSE);
        if (dep instanceof ArchiveDeployment && (rootFile = (arc = (ArchiveDeployment)dep).getRootFile()) == null) {
            rootFile = new ResourceLoaderAdapter(dep.getInitialClassLoader());
            arc.setRootFile(rootFile);
        }
        if ((rtcl = dep.getRuntimeClassLoader()) == null) {
            this.log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"USING_INITAL_CLASS_LAODER_AS_RUNTIME_LAODER", (Object[])new Object[0]), (Throwable)new IllegalArgumentException());
            dep.setRuntimeClassLoader(dep.getInitialClassLoader());
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            if (ep.getShortName() == null) {
                String name = ep.getTargetBeanName();
                String shortName = name.substring(name.lastIndexOf(46) + 1);
                ep.setShortName(shortName);
            }
            if (((HttpEndpoint)ep).getURLPattern() != null) continue;
            ((HttpEndpoint)ep).setURLPattern("/*");
        }
    }
}

