/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection.resolvers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.metadata.injection.ReferenceResolver;

public abstract class AbstractReferenceResolver<A extends Annotation>
implements ReferenceResolver {
    private static final ResourceBundle bundle = BundleUtils.getBundle(AbstractReferenceResolver.class);
    private final Class<A> annotationClass;

    public AbstractReferenceResolver(Class<A> annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ANNOTATION_CLASS_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        this.annotationClass = annotationClass;
    }

    public final String resolve(AccessibleObject accessibleObject) {
        if (!this.canResolve(accessibleObject)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_RESOLVE", (Object[])new Object[]{accessibleObject}));
        }
        if (accessibleObject.getClass().equals(Method.class)) {
            return this.resolveMethod((Method)accessibleObject);
        }
        return this.resolveField((Field)accessibleObject);
    }

    public final boolean canResolve(AccessibleObject accessibleObject) {
        this.assertNotNull(accessibleObject);
        boolean isField = accessibleObject.getClass().equals(Field.class);
        boolean isMethod = accessibleObject.getClass().equals(Method.class);
        boolean hasAnnotation = accessibleObject.getAnnotation(this.annotationClass) != null;
        return (isField || isMethod) && hasAnnotation;
    }

    protected abstract String resolveMethod(Method var1);

    protected abstract String resolveField(Field var1);

    private void assertNotNull(AccessibleObject accessibleObject) {
        if (accessibleObject == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ACCESSIBLEOBJECT_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
    }
}

