/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection.finders;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.injection.InjectionException;

final class ReflectionUtils {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static void assertNoPrimitiveParameters(Method method, Class<? extends Annotation> annotation) {
        for (Class<?> type : method.getParameterTypes()) {
            if (!type.isPrimitive()) continue;
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"METHOD_CANNOT_DECLARE_PRIMITIVE_PARAMETERS", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), method}));
        }
    }

    public static void assertNoPrimitiveParameters(Method method) {
        ReflectionUtils.assertNoPrimitiveParameters(method, null);
    }

    public static void assertNotPrimitiveType(Field field, Class<? extends Annotation> annotation) {
        if (field.getType().isPrimitive()) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FIELD_CANNOT_BE_OF_PRIMITIVE_TYPE", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), field}));
        }
    }

    public static void assertNotPrimitiveType(Field field) {
        ReflectionUtils.assertNotPrimitiveType(field, null);
    }

    public static void assertNoParameters(Method method, Class<? extends Annotation> annotation) {
        if (method.getParameterTypes().length != 0) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"METHOD_HAVE_TO_HAVE_NO_PARAMETERS", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), method}));
        }
    }

    public static void assertNoParameters(Method method) {
        ReflectionUtils.assertNoParameters(method, null);
    }

    public static void assertVoidReturnType(Method method, Class<? extends Annotation> annotation) {
        if (!method.getReturnType().equals(Void.class) && !method.getReturnType().equals(Void.TYPE)) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"METHOD_HAVE_TO_RETURN_VOID", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), method}));
        }
    }

    public static void assertVoidReturnType(Method method) {
        ReflectionUtils.assertVoidReturnType(method, null);
    }

    public static void assertNotVoidType(Field field, Class<? extends Annotation> annotation) {
        if (field.getClass().equals(Void.class) && field.getClass().equals(Void.TYPE)) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FIELD_CANNOT_BE_OF_VOID_TYPE", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), field}));
        }
    }

    public static void assertNotVoidType(Field field) {
        ReflectionUtils.assertNotVoidType(field, null);
    }

    public static void assertNoCheckedExceptionsAreThrown(Method method, Class<? extends Annotation> annotation) {
        Class<?>[] declaredExceptions = method.getExceptionTypes();
        for (int i = 0; i < declaredExceptions.length; ++i) {
            Class<RuntimeException> exception = declaredExceptions[i];
            if (exception.isAssignableFrom(RuntimeException.class)) continue;
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"METHOD_CANNOT_THROW_CHECKED_EXCEPTIONS", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), method}));
        }
    }

    public static void assertNoCheckedExceptionsAreThrown(Method method) {
        ReflectionUtils.assertNoCheckedExceptionsAreThrown(method, null);
    }

    public static void assertNotStatic(Method method, Class<? extends Annotation> annotation) {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"METHOD_CANNOT_BE_STATIC", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), method}));
        }
    }

    public static void assertNotStatic(Method method) {
        ReflectionUtils.assertNotStatic(method, null);
    }

    public static void assertNotStatic(Field field, Class<? extends Annotation> annotation) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FIELD_CANNOT_BE_STATIC", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), field}));
        }
    }

    public static void assertNotStatic(Field field) {
        ReflectionUtils.assertNotStatic(field, null);
    }

    public static void assertNotFinal(Field field, Class<? extends Annotation> annotation) {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FIELD_CANNOT_BE_FINAL", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), field}));
        }
    }

    public static void assertNotFinal(Field field) {
        ReflectionUtils.assertNotFinal(field, null);
    }

    public static void assertOneParameter(Method method, Class<? extends Annotation> annotation) {
        if (method.getParameterTypes().length != 1) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"METHOD_HAVE_TO_DECLARE_EXACTLY_ONE_PARAMETER", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), method}));
        }
    }

    public static void assertOneParameter(Method method) {
        ReflectionUtils.assertOneParameter(method, null);
    }

    public static void assertValidSetterName(Method method, Class<? extends Annotation> annotation) {
        boolean isUpperCasedPropertyName;
        String methodName = method.getName();
        boolean correctMethodNameLength = methodName.length() > 3;
        boolean isSetterMethodName = methodName.startsWith("set");
        boolean bl = isUpperCasedPropertyName = correctMethodNameLength ? Character.isUpperCase(methodName.charAt(3)) : false;
        if (!(correctMethodNameLength && isSetterMethodName && isUpperCasedPropertyName)) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"METHOD_DOESN'T_FOLLOW_JAVA_BEANS_SETTER_METHOD_NAME", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation), method}));
        }
    }

    public static void assertValidSetterName(Method method) {
        ReflectionUtils.assertValidSetterName(method, null);
    }

    public static void assertOnlyOneMethod(Collection<Method> methods, Class<? extends Annotation> annotation) {
        if (methods.size() > 1) {
            throw new InjectionException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ONLY_ONE_METHOD_CAN_EXIST", (Object[])new Object[]{ReflectionUtils.getAnnotationMessage(annotation)}));
        }
    }

    public static void assertOnlyOneMethod(Collection<Method> methods) {
        ReflectionUtils.assertOnlyOneMethod(methods, null);
    }

    private static String getAnnotationMessage(Class<? extends Annotation> annotation) {
        return annotation == null ? "" : "annotated with @" + annotation + " annotation ";
    }
}

