/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.management.AbstractServerConfigMBean;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.StackConfig;
import org.jboss.wsf.spi.management.StackConfigFactory;
import org.jboss.wsf.spi.management.WebServerInfo;
import org.jboss.wsf.spi.management.WebServerInfoFactory;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;

public abstract class AbstractServerConfig
implements AbstractServerConfigMBean,
ServerConfig {
    protected static final ObjectName OBJECT_NAME_SERVER_CONFIG = ObjectNameFactory.create("jboss.system:type=ServerConfig");
    private MBeanServer mbeanServer;
    private String webServiceHost = "jbossws.undefined.host";
    private int webServicePort;
    private int webServiceSecurePort;
    private boolean modifySOAPAddress;
    protected StackConfig stackConfig;
    private final List<ClientConfig> clientConfigs = Collections.synchronizedList(new ArrayList(2));
    private final List<EndpointConfig> endpointConfigs = Collections.synchronizedList(new ArrayList(3));

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public String getWebServiceHost() {
        return this.webServiceHost;
    }

    public void setWebServiceHost(String host) throws UnknownHostException {
        if (host == null || host.trim().length() == 0) {
            Loggers.MANAGEMENT_LOGGER.usingUndefinedWebServicesHost("jbossws.undefined.host");
            host = "jbossws.undefined.host";
        }
        if ("0.0.0.0".equals(host)) {
            InetAddress localHost = InetAddress.getLocalHost();
            if (Loggers.MANAGEMENT_LOGGER.isDebugEnabled()) {
                Loggers.MANAGEMENT_LOGGER.usingLocalHostWebServicesHost(localHost.getHostName());
            }
            host = localHost.getHostName();
        }
        this.webServiceHost = this.toIPv6URLFormat("127.0.0.1".equals(host) ? "localhost" : host);
    }

    private String toIPv6URLFormat(String host) {
        boolean isIPv6Address = false;
        try {
            isIPv6Address = !"jbossws.undefined.host".equals(host) && InetAddress.getByName(host) instanceof Inet6Address;
        }
        catch (UnknownHostException e) {
            Loggers.MANAGEMENT_LOGGER.couldNotGetAddressForHost(host, e);
        }
        boolean isIPv6Formatted = isIPv6Address && host.startsWith("[");
        return isIPv6Address && !isIPv6Formatted ? "[" + host + "]" : host;
    }

    public void setWebServicePort(int port) {
        this.webServicePort = port;
    }

    public void setWebServiceSecurePort(int port) {
        this.webServiceSecurePort = port;
    }

    public boolean isModifySOAPAddress() {
        return this.modifySOAPAddress;
    }

    public void setModifySOAPAddress(boolean modify) {
        this.modifySOAPAddress = modify;
    }

    public int getWebServicePort() {
        int localPort;
        if (this.webServicePort <= 0) {
            this.webServicePort = this.getConnectorPort(false);
        }
        if ((localPort = this.webServicePort) <= 0) {
            if (Loggers.MANAGEMENT_LOGGER.isDebugEnabled()) {
                Loggers.MANAGEMENT_LOGGER.unableToCalculateWebServicesPort("8080");
            }
            localPort = 8080;
        }
        return localPort;
    }

    public int getWebServiceSecurePort() {
        int localPort;
        if (this.webServiceSecurePort <= 0) {
            this.webServiceSecurePort = this.getConnectorPort(true);
        }
        if ((localPort = this.webServiceSecurePort) <= 0) {
            if (Loggers.MANAGEMENT_LOGGER.isDebugEnabled()) {
                Loggers.MANAGEMENT_LOGGER.unableToCalculateWebServicesSecurePort("8443");
            }
            localPort = 8443;
        }
        return localPort;
    }

    private int getConnectorPort(boolean secure) {
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        SPIProvider spiProvider = SPIProviderResolver.getInstance((ClassLoader)cl).getProvider();
        int port = 0;
        try {
            WebServerInfo webServerInfo = ((WebServerInfoFactory)spiProvider.getSPI(WebServerInfoFactory.class, cl)).newWebServerInfo();
            port = webServerInfo.getPort("HTTP/1.1", secure);
        }
        catch (WSFException e) {
            Loggers.MANAGEMENT_LOGGER.couldNotGetPortFromConfiguredHTTPConnector();
        }
        return port;
    }

    public void create() throws Exception {
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        SPIProvider spiProvider = SPIProviderResolver.getInstance((ClassLoader)cl).getProvider();
        this.stackConfig = ((StackConfigFactory)spiProvider.getSPI(StackConfigFactory.class, cl)).getStackConfig();
        Loggers.MANAGEMENT_LOGGER.startingWSServerConfig(this.getImplementationTitle(), this.getImplementationVersion());
        MBeanServer mbeanServer = this.getMbeanServer();
        if (mbeanServer != null) {
            mbeanServer.registerMBean(this, AbstractServerConfigMBean.OBJECT_NAME);
        }
    }

    public void destroy() throws Exception {
        MBeanServer mbeanServer = this.getMbeanServer();
        if (mbeanServer != null) {
            mbeanServer.unregisterMBean(AbstractServerConfigMBean.OBJECT_NAME);
        }
    }

    public String getImplementationTitle() {
        return this.stackConfig.getImplementationTitle();
    }

    public String getImplementationVersion() {
        return this.stackConfig.getImplementationVersion();
    }

    public void addEndpointConfig(EndpointConfig config) {
        this.endpointConfigs.add(config);
    }

    public void addClientConfig(ClientConfig config) {
        this.clientConfigs.add(config);
    }

    public List<EndpointConfig> getEndpointConfigs() {
        return this.endpointConfigs;
    }

    public List<ClientConfig> getClientConfigs() {
        return this.clientConfigs;
    }
}

