/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.serviceref;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import javax.naming.NamingException;
import org.jboss.ws.common.Messages;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

final class ServiceRefSerializer {
    static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";

    private ServiceRefSerializer() {
    }

    static byte[] marshall(UnifiedServiceRefMetaData obj) throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            throw Messages.MESSAGES.cannotMarshallServiceRefMetaData(e);
        }
        return baos.toByteArray();
    }

    static UnifiedServiceRefMetaData unmarshall(byte[] data) throws NamingException {
        UnifiedServiceRefMetaData sref;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            TCCLAwareObjectInputStream ois = new TCCLAwareObjectInputStream(bais);
            sref = (UnifiedServiceRefMetaData)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw Messages.MESSAGES.cannotUnMarshallServiceRefMetaData(e);
        }
        catch (ClassNotFoundException e) {
            throw Messages.MESSAGES.cannotUnMarshallServiceRefMetaData(e);
        }
        return sref;
    }

    private static final class TCCLAwareObjectInputStream
    extends ObjectInputStream {
        private TCCLAwareObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                ClassLoader currentThreadLoader = Thread.currentThread().getContextClassLoader();
                if (currentThreadLoader != null) {
                    return currentThreadLoader.loadClass(desc.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.resolveClass(desc);
        }
    }
}

