/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.ws.common.Messages;
import org.jboss.wsf.spi.util.StAXUtils;

public final class SOAPAddressWSDLParser {
    public static final String SOAP_OVER_JMS_NS = "http://www.w3.org/2010/soapjms/";
    private static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    private static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String SOAP12_NS = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private static final String DEFINITIONS = "definitions";
    private static final String SERVICE = "service";
    private static final String PORT = "port";
    private static final String BINDING = "binding";
    private static final String TRANSPORT = "transport";
    private static final String ADDRESS = "address";
    private static final String LOCATION = "location";
    private static final String NAME = "name";
    private static final String TARGET_NAMESPACE = "targetNamespace";
    private WSDLMetaData metadata;

    public SOAPAddressWSDLParser(URL wsdlUrl) {
        this.metadata = SOAPAddressWSDLParser.getMetaData(wsdlUrl);
    }

    public String filterSoapAddress(QName serviceName, QName portName, String transportNamespace) {
        WSDLBindingMetaData bmd;
        WSDLPortMetaData pmd;
        WSDLServiceMetaData smd = this.metadata.getServices().get(serviceName);
        if (smd != null && (pmd = smd.getPorts().get(portName)) != null && (bmd = this.metadata.getBindings().get(pmd.getBindingName())) != null && transportNamespace.equals(bmd.getSoapTransport())) {
            return pmd.getSoapAddress();
        }
        return null;
    }

    protected static WSDLMetaData getMetaData(URL wsdlUrl) {
        InputStream is = null;
        try {
            is = wsdlUrl.openStream();
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader((InputStream)is);
            WSDLMetaData wSDLMetaData = SOAPAddressWSDLParser.getMetaData(xmlr, wsdlUrl);
            return wSDLMetaData;
        }
        catch (Exception e) {
            throw Messages.MESSAGES.failedToRead(wsdlUrl.toExternalForm(), e.getMessage(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static WSDLMetaData getMetaData(XMLStreamReader reader, URL wsdlUrl) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        WSDLMetaData metadata = new WSDLMetaData();
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match((XMLStreamReader)reader, (String)WSDL_NS, (String)DEFINITIONS)) {
                    String targetNS = reader.getAttributeValue(null, TARGET_NAMESPACE);
                    SOAPAddressWSDLParser.parseDefinitions(reader, metadata, targetNS, wsdlUrl);
                    break;
                }
                throw Messages.MESSAGES.unexpectedElement(wsdlUrl.toExternalForm(), reader.getLocalName());
            }
        }
        return metadata;
    }

    private static void parseDefinitions(XMLStreamReader reader, WSDLMetaData metadata, String targetNS, URL wsdlUrl) throws XMLStreamException {
        block4: while (reader.hasNext()) {
            switch (StAXUtils.nextElement((XMLStreamReader)reader)) {
                case 2: {
                    if (!StAXUtils.match((XMLStreamReader)reader, (String)WSDL_NS, (String)DEFINITIONS)) continue block4;
                    return;
                }
                case 1: {
                    QName name;
                    if (StAXUtils.match((XMLStreamReader)reader, (String)WSDL_NS, (String)SERVICE)) {
                        name = StAXUtils.attributeAsQName((XMLStreamReader)reader, null, (String)NAME, (String)targetNS);
                        WSDLServiceMetaData smd = SOAPAddressWSDLParser.parseService(reader, targetNS, wsdlUrl);
                        smd.setName(name);
                        metadata.getServices().put(smd.getName(), smd);
                        continue block4;
                    }
                    if (!StAXUtils.match((XMLStreamReader)reader, (String)WSDL_NS, (String)BINDING)) continue block4;
                    name = StAXUtils.attributeAsQName((XMLStreamReader)reader, null, (String)NAME, (String)targetNS);
                    WSDLBindingMetaData bmd = SOAPAddressWSDLParser.parseBinding(reader, wsdlUrl);
                    bmd.setName(name);
                    metadata.getBindings().put(bmd.getName(), bmd);
                    continue block4;
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(wsdlUrl.toExternalForm());
    }

    private static WSDLServiceMetaData parseService(XMLStreamReader reader, String targetNS, URL wsdlUrl) throws XMLStreamException {
        WSDLServiceMetaData smd = new WSDLServiceMetaData();
        block4: while (reader.hasNext()) {
            switch (StAXUtils.nextElement((XMLStreamReader)reader)) {
                case 2: {
                    if (!StAXUtils.match((XMLStreamReader)reader, (String)WSDL_NS, (String)SERVICE)) continue block4;
                    return smd;
                }
                case 1: {
                    if (!StAXUtils.match((XMLStreamReader)reader, (String)WSDL_NS, (String)PORT)) continue block4;
                    QName name = StAXUtils.attributeAsQName((XMLStreamReader)reader, null, (String)NAME, (String)targetNS);
                    QName binding = StAXUtils.attributeAsQName((XMLStreamReader)reader, null, (String)BINDING, (String)targetNS);
                    WSDLPortMetaData pmd = SOAPAddressWSDLParser.parsePort(reader, wsdlUrl);
                    pmd.setName(name);
                    pmd.setBindingName(binding);
                    smd.getPorts().put(pmd.getName(), pmd);
                    continue block4;
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(wsdlUrl.toExternalForm());
    }

    private static WSDLPortMetaData parsePort(XMLStreamReader reader, URL wsdlUrl) throws XMLStreamException {
        WSDLPortMetaData pmd = new WSDLPortMetaData();
        block4: while (reader.hasNext()) {
            switch (StAXUtils.nextElement((XMLStreamReader)reader)) {
                case 2: {
                    if (!StAXUtils.match((XMLStreamReader)reader, (String)WSDL_NS, (String)PORT)) continue block4;
                    return pmd;
                }
                case 1: {
                    if (!StAXUtils.match((XMLStreamReader)reader, (String)SOAP_NS, (String)ADDRESS) && !StAXUtils.match((XMLStreamReader)reader, (String)SOAP12_NS, (String)ADDRESS)) continue block4;
                    String location = reader.getAttributeValue(null, LOCATION);
                    pmd.setSoapAddress(location);
                    reader.nextTag();
                    continue block4;
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(wsdlUrl.toExternalForm());
    }

    private static WSDLBindingMetaData parseBinding(XMLStreamReader reader, URL wsdlUrl) throws XMLStreamException {
        WSDLBindingMetaData bmd = new WSDLBindingMetaData();
        block4: while (reader.hasNext()) {
            switch (StAXUtils.nextElement((XMLStreamReader)reader)) {
                case 2: {
                    if (!StAXUtils.match((XMLStreamReader)reader, (String)WSDL_NS, (String)BINDING)) continue block4;
                    return bmd;
                }
                case 1: {
                    if (!StAXUtils.match((XMLStreamReader)reader, (String)SOAP_NS, (String)BINDING) && !StAXUtils.match((XMLStreamReader)reader, (String)SOAP12_NS, (String)BINDING)) continue block4;
                    String transport = reader.getAttributeValue(null, TRANSPORT);
                    bmd.setSoapTransport(transport);
                    reader.nextTag();
                    continue block4;
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(wsdlUrl.toExternalForm());
    }

    private static class WSDLBindingMetaData {
        private String soapTransport;
        private QName name;

        private WSDLBindingMetaData() {
        }

        public String getSoapTransport() {
            return this.soapTransport;
        }

        public void setSoapTransport(String soapTransport) {
            this.soapTransport = soapTransport;
        }

        public QName getName() {
            return this.name;
        }

        public void setName(QName name) {
            this.name = name;
        }
    }

    private static class WSDLPortMetaData {
        private String soapAddress;
        private QName name;
        private QName bindingName;

        private WSDLPortMetaData() {
        }

        public String getSoapAddress() {
            return this.soapAddress;
        }

        public void setSoapAddress(String soapAddress) {
            this.soapAddress = soapAddress;
        }

        public QName getName() {
            return this.name;
        }

        public void setName(QName name) {
            this.name = name;
        }

        public QName getBindingName() {
            return this.bindingName;
        }

        public void setBindingName(QName bindingName) {
            this.bindingName = bindingName;
        }
    }

    private static class WSDLServiceMetaData {
        private QName name;
        private Map<QName, WSDLPortMetaData> ports = new HashMap<QName, WSDLPortMetaData>();

        private WSDLServiceMetaData() {
        }

        public QName getName() {
            return this.name;
        }

        public void setName(QName name) {
            this.name = name;
        }

        public Map<QName, WSDLPortMetaData> getPorts() {
            return this.ports;
        }
    }

    private static class WSDLMetaData {
        private Map<QName, WSDLServiceMetaData> services = new HashMap<QName, WSDLServiceMetaData>();
        private Map<QName, WSDLBindingMetaData> bindings = new HashMap<QName, WSDLBindingMetaData>();

        private WSDLMetaData() {
        }

        public Map<QName, WSDLServiceMetaData> getServices() {
            return this.services;
        }

        public Map<QName, WSDLBindingMetaData> getBindings() {
            return this.bindings;
        }
    }
}

