/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.integration;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.ws.common.integration.SecurityActions;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

public class AbstractDeploymentAspect
implements DeploymentAspect {
    private String provides;
    private String requires;
    private int relativeOrder;
    private boolean isLast;
    private boolean isForJaxWs = true;
    private boolean isForJaxRpc = true;
    private WeakReference<ClassLoader> loader = new WeakReference<ClassLoader>(SecurityActions.getContextClassLoader());

    public ClassLoader getLoader() {
        return this.loader != null ? (ClassLoader)this.loader.get() : null;
    }

    public void setLast(boolean isLast) {
        this.isLast = isLast;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public String getProvides() {
        return this.provides;
    }

    public void setProvides(String provides) {
        this.provides = provides;
    }

    public String getRequires() {
        return this.requires;
    }

    public void setRequires(String requires) {
        this.requires = requires;
    }

    public void setRelativeOrder(int relativeOrder) {
        this.relativeOrder = relativeOrder;
    }

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public void start(Deployment dep) {
    }

    public void stop(Deployment dep) {
    }

    public Set<String> getProvidesAsSet() {
        HashSet<String> condset = new HashSet<String>();
        if (this.provides != null) {
            StringTokenizer st = new StringTokenizer(this.provides, ", \r\n\t");
            while (st.hasMoreTokens()) {
                condset.add(st.nextToken());
            }
        }
        return condset;
    }

    public Set<String> getRequiresAsSet() {
        HashSet<String> condset = new HashSet<String>();
        if (this.requires != null) {
            StringTokenizer st = new StringTokenizer(this.requires, ", \r\n\t");
            while (st.hasMoreTokens()) {
                condset.add(st.nextToken());
            }
        }
        return condset;
    }

    public boolean canHandle(Deployment dep) {
        return this.isForJaxWs && WSHelper.isJaxwsDeployment(dep) || this.isForJaxRpc && WSHelper.isJaxrpcDeployment(dep);
    }

    public boolean isForJaxWs() {
        return this.isForJaxWs;
    }

    public void setForJaxWs(boolean isForJaxWs) {
        this.isForJaxWs = isForJaxWs;
    }

    public boolean isForJaxRpc() {
        return this.isForJaxRpc;
    }

    public void setForJaxRpc(boolean isForJaxRpc) {
        this.isForJaxRpc = isForJaxRpc;
    }
}

