/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.transport;

import Acme.Serve.Serve;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.wsf.framework.transport.HttpDeamon;

public class TJWSHttpDeamon
implements HttpDeamon {
    private int port;
    private Serve server;
    private static final Logger LOG = Logger.getLogger(TJWSHttpDeamon.class);
    private static final Lock CLASS_LOCK = new ReentrantLock();
    private static HttpDeamon INSTANCE = null;
    private boolean started = false;
    private Map<String, Servlet> servlets = new HashMap<String, Servlet>();

    private TJWSHttpDeamon(int port) {
        this.port = port;
        this.server = new Serve();
        Properties properties = new Properties();
        properties.put("port", (Object)port);
        properties.setProperty("nohup", "nohup");
        this.server.arguments = properties;
        this.server.addDefaultServlets(null);
        this.server.addServlet("/", (Servlet)new HelloServlet("JBossWS HttpDeamon"));
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        CLASS_LOCK.lock();
        try {
            if (!this.started) {
                Thread t = new Thread(new DoServe(this.server));
                t.start();
                this.started = true;
            }
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    public void stop() {
        try {
            this.server.notifyStop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.server.destroyAllServlets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletContext(String contextPath, String urlPattern, Servlet servlet) {
        CLASS_LOCK.lock();
        try {
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            this.server.addServlet(contextPath, servlet);
            this.servlets.put(contextPath, servlet);
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServletContext(String contextPath, String urlPattern) {
        CLASS_LOCK.lock();
        try {
            Servlet servlet = this.servlets.remove(contextPath);
            if (servlet != null) {
                this.server.destroyAllServlets();
                for (String ctx : this.servlets.keySet()) {
                    this.server.addServlet(ctx, this.servlets.get(ctx));
                }
                this.server.addServlet("/", (Servlet)new HelloServlet("JBossWS HttpDeamon"));
            }
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpDeamon getInstance(int port) {
        CLASS_LOCK.lock();
        try {
            if (INSTANCE == null) {
                INSTANCE = new TJWSHttpDeamon(port);
                try {
                    INSTANCE.start();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to start HttpDeamon", e);
                }
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    public void run() {
                        try {
                            INSTANCE.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, "HttpDeamonShutDownHook"));
            } else {
                LOG.warn((Object)("There is already a HttpDeamon running on port: " + INSTANCE.getPort()));
            }
            HttpDeamon httpDeamon = INSTANCE;
            return httpDeamon;
        }
        finally {
            CLASS_LOCK.unlock();
        }
    }

    private class DoServe
    implements Runnable {
        private Serve server;

        public void run() {
            this.server.serve();
        }

        public DoServe(Serve server) {
            this.server = server;
        }
    }

    public static class HelloServlet
    extends HttpServlet {
        String greeting = "Hello";

        public HelloServlet() {
        }

        public HelloServlet(String hi) {
            this.greeting = hi;
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/plain");
            response.setStatus(200);
            response.getWriter().println(this.greeting);
        }
    }
}

