/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.HashMap;
import java.util.Map;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.transport.HttpSpec;
import org.jboss.wsf.spi.transport.ListenerRef;
import org.jboss.wsf.spi.transport.Protocol;
import org.jboss.wsf.spi.transport.TransportManager;
import org.jboss.wsf.spi.transport.TransportManagerFactory;
import org.jboss.wsf.spi.transport.TransportSpec;

public class HttpTransportDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment dep, WSFRuntime runtime) {
        TransportManagerFactory tmf = runtime.getTransportManagerFactory();
        TransportManager httpTransport = tmf.createTransportManager(Protocol.HTTP);
        String contextRoot = dep.getService().getContextRoot();
        if (contextRoot == null) {
            throw new IllegalStateException("Cannot obtain context root");
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            String urlPattern = ep.getURLPattern();
            if (urlPattern == null) {
                throw new IllegalStateException("Cannot obtain url pattern");
            }
            if (urlPattern.endsWith("/*")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 2);
            }
            HttpSpec spec = new HttpSpec(contextRoot, urlPattern);
            String servletClass = (String)dep.getProperty("org.jboss.ws.webapp.ServletClass");
            if (servletClass == null) {
                throw new IllegalStateException("Cannot obtain context property: org.jboss.ws.webapp.ServletClass");
            }
            Object ctxProps = dep.getProperty("org.jboss.ws.webapp.ContextParameterMap");
            Map ctxParams = ctxProps != null ? (Map)ctxProps : new HashMap();
            spec.setServletClass(servletClass);
            spec.getContextParameter().putAll(ctxParams);
            ListenerRef ref = httpTransport.createListener(ep, (TransportSpec)spec);
            ep.addAttachment(ListenerRef.class, (Object)ref);
            ep.setAddress(ref.getAddress().toString());
        }
    }

    public void destroy(Deployment dep, WSFRuntime runtime) {
        TransportManagerFactory tmf = runtime.getTransportManagerFactory();
        TransportManager httpTransport = tmf.createTransportManager(Protocol.HTTP);
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ListenerRef listenerRef = (ListenerRef)ep.getAttachment(ListenerRef.class);
            httpTransport.destroyListener(listenerRef);
        }
    }
}

