/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;

public class URLPatternDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment dep, WSFRuntime runtime) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            String urlPattern = ep.getURLPattern();
            if (urlPattern != null) continue;
            urlPattern = this.getExplicitPattern(dep, ep);
            if (urlPattern == null) {
                urlPattern = this.getImplicitPattern(dep, ep);
            }
            if (!urlPattern.startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            ep.setURLPattern(urlPattern);
        }
    }

    protected String getExplicitPattern(Deployment dep, Endpoint ep) {
        Class beanClass;
        WebContext anWebContext;
        EJBArchiveMetaData appMetaData;
        String urlPattern = null;
        JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
        if (webMetaData != null) {
            String epName = ep.getShortName();
            urlPattern = (String)webMetaData.getServletMappings().get(epName);
            if (urlPattern == null) {
                throw new IllegalStateException("Cannot obtain servlet mapping for: " + epName);
            }
        }
        if ((appMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class)) != null && appMetaData.getBeanByEjbName(ep.getShortName()) != null) {
            EJBMetaData bmd = appMetaData.getBeanByEjbName(ep.getShortName());
            urlPattern = bmd.getPortComponentURI();
        }
        if (urlPattern == null && (anWebContext = (beanClass = ep.getTargetBeanClass()).getAnnotation(WebContext.class)) != null && anWebContext.urlPattern().length() > 0) {
            urlPattern = anWebContext.urlPattern();
        }
        return urlPattern;
    }

    protected String getImplicitPattern(Deployment dep, Endpoint ep) {
        String urlPattern = ep.getShortName();
        return urlPattern;
    }
}

