/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.Arrays;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;

public class VirtualHostDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment dep) {
        String[] virtualHosts = dep.getService().getVirtualHosts();
        if (virtualHosts == null) {
            dep.getService().setVirtualHosts(this.getExplicitVirtualHosts(dep));
        }
    }

    protected String[] getExplicitVirtualHosts(Deployment dep) {
        Object[] virtualHosts = null;
        for (Endpoint ep : dep.getService().getEndpoints()) {
            Class implClass = ep.getTargetBeanClass();
            WebContext anWebContext = implClass.getAnnotation(WebContext.class);
            if (anWebContext == null || anWebContext.virtualHosts() == null || anWebContext.virtualHosts().length <= 0) continue;
            String[] anVirtualHosts = anWebContext.virtualHosts();
            Object[] temp = new String[anVirtualHosts.length];
            System.arraycopy(anVirtualHosts, 0, temp, 0, anVirtualHosts.length);
            Arrays.sort(temp);
            if (virtualHosts == null) {
                virtualHosts = temp;
                continue;
            }
            if (Arrays.equals(virtualHosts, temp)) continue;
            throw new IllegalStateException("virtualHosts must be the same for all deployed endpoints");
        }
        return virtualHosts;
    }
}

