/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework;

import org.jboss.logging.Logger;
import org.jboss.wsf.framework.deployment.DefaultDeploymentAspectManagerFactory;
import org.jboss.wsf.framework.deployment.DefaultDeploymentModelFactory;
import org.jboss.wsf.framework.deployment.DefaultLifecycleHandlerFactory;
import org.jboss.wsf.framework.http.DefaultHttpContextFactory;
import org.jboss.wsf.framework.http.DefaultHttpServerFactory;
import org.jboss.wsf.framework.invocation.DefaultResourceInjectorFactory;
import org.jboss.wsf.framework.management.DefaultEndpointMetricsFactory;
import org.jboss.wsf.framework.management.ServerConfigFactoryImpl;
import org.jboss.wsf.framework.serviceref.DefaultServiceRefHandlerFactory;
import org.jboss.wsf.framework.serviceref.DefaultServiceRefMetaDataParserFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.deployment.DeploymentAspectManagerFactory;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.LifecycleHandlerFactory;
import org.jboss.wsf.spi.http.HttpContextFactory;
import org.jboss.wsf.spi.http.HttpServerFactory;
import org.jboss.wsf.spi.invocation.InvocationHandlerFactory;
import org.jboss.wsf.spi.invocation.RequestHandlerFactory;
import org.jboss.wsf.spi.invocation.ResourceInjectorFactory;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.wsf.spi.invocation.WebServiceContextFactory;
import org.jboss.wsf.spi.management.EndpointMetricsFactory;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.management.StackConfigFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.ServiceRefMetaDataParserFactory;
import org.jboss.wsf.spi.serviceref.ServiceRefBinderFactory;
import org.jboss.wsf.spi.serviceref.ServiceRefHandlerFactory;
import org.jboss.wsf.spi.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultSPIProvider
extends SPIProvider {
    private static final Logger log = Logger.getLogger(DefaultSPIProvider.class);

    DefaultSPIProvider() {
    }

    public <T> T getSPI(Class<T> spiType) {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug((Object)("provide SPI '" + spiType + "'"));
        }
        T returnType = null;
        if (DeploymentAspectManagerFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, DefaultDeploymentAspectManagerFactory.class.getName());
        }
        if (DeploymentModelFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, DefaultDeploymentModelFactory.class.getName());
        } else if (EndpointMetricsFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, DefaultEndpointMetricsFactory.class.getName());
        } else if (HttpContextFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, DefaultHttpContextFactory.class.getName());
        } else if (HttpServerFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, DefaultHttpServerFactory.class.getName());
        } else if (LifecycleHandlerFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, DefaultLifecycleHandlerFactory.class.getName());
        } else if (ResourceInjectorFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, DefaultResourceInjectorFactory.class.getName());
        } else if (ServiceRefHandlerFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, DefaultServiceRefHandlerFactory.class.getName());
        } else if (ServiceRefMetaDataParserFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, DefaultServiceRefMetaDataParserFactory.class.getName());
        } else if (StackConfigFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, null);
        } else if (ServerConfigFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, ServerConfigFactoryImpl.class.getName());
        } else if (EndpointRegistryFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, null);
        } else if (InvocationHandlerFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, null);
        } else if (RequestHandlerFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, null);
        } else if (SecurityAdaptorFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, null);
        } else if (ServiceRefBinderFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, null);
        } else if (WebServiceContextFactory.class.equals(spiType)) {
            returnType = this.loadService(spiType, null);
        }
        if (returnType == null) {
            throw new WSFException("Failed to provide SPI '" + spiType + "'");
        }
        if (debugEnabled) {
            log.debug((Object)(spiType + " Implementation: " + returnType));
        }
        return returnType;
    }

    private <T> T loadService(Class<T> spiType, String defaultImpl) {
        return (T)ServiceLoader.loadService((String)spiType.getName(), (String)defaultImpl);
    }
}

