/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.List;
import java.util.Map;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.HttpEndpoint;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;

public class EndpointAddressDeploymentAspect
extends AbstractDeploymentAspect {
    public void start(Deployment dep) {
        String contextRoot = dep.getService().getContextRoot();
        if (contextRoot == null) {
            throw new IllegalStateException("Cannot obtain context root");
        }
        String protocol = (String)dep.getService().getProperty("protocol");
        String host = (String)dep.getService().getProperty("host");
        Integer port = (Integer)dep.getService().getProperty("port");
        Integer securePort = null;
        if (protocol == null) {
            SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
            ServerConfigFactory spi = (ServerConfigFactory)provider.getSPI(ServerConfigFactory.class);
            ServerConfig serverConfig = spi.getServerConfig();
            host = serverConfig.getWebServiceHost();
            port = serverConfig.getWebServicePort();
            securePort = serverConfig.getWebServiceSecurePort();
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            boolean confidential = this.isConfidentialTransportGuarantee(dep, ep);
            int currentPort = confidential ? securePort : port;
            String hostAndPort = host + (currentPort > 0 ? ":" + currentPort : "");
            HttpEndpoint httpEp = (HttpEndpoint)ep;
            String urlPattern = httpEp.getURLPattern();
            if (urlPattern == null) {
                throw new IllegalStateException("Cannot obtain url pattern");
            }
            if (urlPattern.endsWith("/*")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 2);
            }
            protocol = confidential ? "https://" : "http://";
            httpEp.setAddress(protocol + hostAndPort + contextRoot + urlPattern);
        }
    }

    protected boolean isConfidentialTransportGuarantee(Deployment dep, Endpoint ep) {
        String transportGuarantee = null;
        if (Deployment.DeploymentType.JAXWS_JSE == dep.getType()) {
            JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
            if (webMetaData != null) {
                String servletLink = ep.getShortName();
                Map servletMappings = webMetaData.getServletMappings();
                String urlPattern = (String)servletMappings.get(servletLink);
                if (urlPattern == null) {
                    throw new RuntimeException("Cannot find <url-pattern> for servlet-name: " + servletLink);
                }
                List securityList = webMetaData.getSecurityMetaData();
                for (JSESecurityMetaData currentSecurity : securityList) {
                    if (currentSecurity.getTransportGuarantee() == null || currentSecurity.getTransportGuarantee().length() <= 0) continue;
                    for (JSESecurityMetaData.JSEResourceCollection currentCollection : currentSecurity.getWebResources()) {
                        for (String currentUrlPattern : currentCollection.getUrlPatterns()) {
                            if (!urlPattern.equals(currentUrlPattern) && !"/*".equals(currentUrlPattern)) continue;
                            transportGuarantee = currentSecurity.getTransportGuarantee();
                        }
                    }
                }
            }
        } else if (Deployment.DeploymentType.JAXWS_EJB3 == dep.getType()) {
            Class implClass = ep.getTargetBeanClass();
            WebContext anWebContext = implClass.getAnnotation(WebContext.class);
            if (anWebContext != null) {
                transportGuarantee = anWebContext.transportGuarantee();
            }
            if (anWebContext == null || transportGuarantee == null || transportGuarantee.length() == 0) {
                EJBSecurityMetaData ejbSecurityMD;
                String ejbName = ep.getShortName();
                EJBArchiveMetaData ejbArchiveMD = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
                EJBMetaData ejbMD = ejbArchiveMD != null ? ejbArchiveMD.getBeanByEjbName(ejbName) : null;
                EJBSecurityMetaData eJBSecurityMetaData = ejbSecurityMD = ejbMD != null ? ejbMD.getSecurityMetaData() : null;
                if (ejbSecurityMD != null) {
                    transportGuarantee = ejbSecurityMD.getTransportGuarantee();
                }
            }
        }
        return "CONFIDENTIAL".equals(transportGuarantee);
    }
}

