/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;

public class EndpointNameDeploymentAspect
extends AbstractDeploymentAspect {
    public void start(Deployment dep) {
        String contextRoot = dep.getService().getContextRoot();
        if (contextRoot == null || !contextRoot.startsWith("/")) {
            throw new IllegalStateException("Context root expected to start with leading slash: " + contextRoot);
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            EJBMetaData bmd;
            StringBuilder name = new StringBuilder("jboss.ws:");
            name.append("context=" + contextRoot.substring(1) + ",");
            name.append("endpoint=" + ep.getShortName());
            EJBArchiveMetaData uapp = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
            if (uapp != null && (bmd = uapp.getBeanByEjbName(ep.getShortName())) instanceof MDBMetaData) {
                String destName = ((MDBMetaData)bmd).getDestinationJndiName();
                name.append(",jms=" + destName);
            }
            ep.setName(ObjectNameFactory.create((String)name.toString()));
        }
    }
}

