/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.framework.serviceref;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Referenceable;

import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefBinder;
import org.jboss.wsf.spi.serviceref.ServiceRefBinderFactory;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;

/**
 * Bind service refs in the client's ENC
 * for every service-ref element in the deployment descriptor.
 *
 * @author Thomas.Diesler@jboss.org
 * @author Heiko.Braun@jboss.com
 * @author <a href="mailto:ropalka@redhat.com">Richard Opalka</a>
 * @since 04-Nov-2006
 */
public class DefaultServiceRefHandler implements ServiceRefHandler
{
   @Override
   @Deprecated
   public void bindServiceRef(final Context encCtx, final String encName, final UnifiedVirtualFile ignored,
         final ClassLoader loader, final ServiceRefMetaData serviceRefMD) throws NamingException
   {
      final UnifiedServiceRefMetaData serviceRefUMDM = (UnifiedServiceRefMetaData) serviceRefMD;
      final Type bindingType = getServiceRefType(serviceRefUMDM, loader);

      this.getBinder(bindingType).setupServiceRef(encCtx, encName, null, serviceRefUMDM, loader);
   }


   @Override
   public Referenceable createReferenceable(UnifiedServiceRefMetaData serviceRef, ClassLoader loader)
   {
      final Type bindingType = getServiceRefType(serviceRef, loader);

      return this.getBinder(bindingType).createReferenceable(serviceRef, loader);
   }

   private ServiceRefBinder getBinder(final Type binderType)
   {
      final SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
      final ServiceRefBinderFactory serviceRefBindingFactory = spiProvider.getSPI(ServiceRefBinderFactory.class);

      return serviceRefBindingFactory.newServiceRefBinder(binderType);
   }

   private Type getServiceRefType(final UnifiedServiceRefMetaData serviceRef, final ClassLoader loader)
   {
      // Both service-ref-type and annotated element are JAXWS specific
      if (serviceRef.getServiceRefType() != null || serviceRef.getAnnotatedElement() != null)
         return Type.JAXWS;

      // The mapping-file is JAXRPC specific
      if (serviceRef.getMappingFile() != null)
         return Type.JAXRPC;

      final String serviceInterfaceName = serviceRef.getServiceInterface();
      if (serviceInterfaceName == null)
         throw new IllegalStateException("<service-interface> cannot be null");

      try
      {
         final Class<?> siClass = loader.loadClass(serviceInterfaceName);
         if (javax.xml.ws.Service.class.isAssignableFrom(siClass))
            return Type.JAXWS;
         else if (javax.xml.rpc.Service.class.isAssignableFrom(siClass))
            return Type.JAXRPC;
         else
            throw new IllegalStateException("Illegal service interface: " + serviceInterfaceName);
      }
      catch (ClassNotFoundException e)
      {
         throw new IllegalStateException("Cannot load <service-interface>: " + serviceInterfaceName);
      }
   }
}
