/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.ws.WebServiceException;
import org.jboss.ejb.EjbModule;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.StatelessSessionContainer;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.PayloadKey;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.container.jboss42.ServiceEndpointInterceptor;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.HandlerCallback;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;

public class InvocationHandlerEJB21
extends InvocationHandler {
    private static final Logger log = Logger.getLogger(InvocationHandlerEJB21.class);
    private String jndiName;
    private MBeanServer server;
    private ObjectName objectName;

    public org.jboss.wsf.spi.invocation.Invocation createInvocation() {
        return new org.jboss.wsf.spi.invocation.Invocation();
    }

    public void init(Endpoint ep) {
        String ejbName = ep.getShortName();
        Deployment dep = ep.getService().getDeployment();
        EJBArchiveMetaData apMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
        EJBMetaData beanMetaData = apMetaData.getBeanByEjbName(ejbName);
        if (beanMetaData == null) {
            throw new WebServiceException("Cannot obtain ejb meta data for: " + ejbName);
        }
        this.jndiName = beanMetaData.getContainerObjectNameJndiName();
        if (this.jndiName == null) {
            throw new WebServiceException("Cannot obtain JNDI name for: " + ejbName);
        }
        this.server = MBeanServerLocator.locateJBoss();
        this.objectName = ObjectNameFactory.create((String)("jboss.j2ee:jndiName=" + this.jndiName + ",service=EJB"));
        if (!this.server.isRegistered(this.objectName)) {
            throw new WebServiceException("Cannot find service endpoint target: " + this.objectName);
        }
        try {
            EjbModule ejbModule = (EjbModule)this.server.getAttribute(this.objectName, "EjbModule");
            StatelessSessionContainer container = (StatelessSessionContainer)ejbModule.getContainer(ejbName);
            boolean injectionPointFound = false;
            Interceptor prev = container.getInterceptor();
            while (prev != null && prev.getNext() != null) {
                Interceptor next = prev.getNext();
                if (next.getNext() == null) {
                    log.debug((Object)("Inject service endpoint interceptor after: " + prev.getClass().getName()));
                    ServiceEndpointInterceptor sepInterceptor = new ServiceEndpointInterceptor();
                    prev.setNext((Interceptor)sepInterceptor);
                    sepInterceptor.setNext(next);
                    injectionPointFound = true;
                }
                prev = next;
            }
            if (!injectionPointFound) {
                log.warn((Object)"Cannot service endpoint interceptor injection point");
            }
        }
        catch (Exception ex) {
            log.warn((Object)"Cannot add service endpoint interceptor", (Throwable)ex);
        }
    }

    public void invoke(Endpoint ep, org.jboss.wsf.spi.invocation.Invocation inv) throws Exception {
        log.debug((Object)("Invoke: " + inv.getJavaMethod().getName()));
        try {
            Invocation jbInv = this.getMBeanInvocation(inv);
            String[] sig = new String[]{Invocation.class.getName()};
            Object retObj = this.server.invoke(this.objectName, "invoke", new Object[]{jbInv}, sig);
            inv.setReturnValue(retObj);
        }
        catch (Exception e) {
            this.handleInvocationException(e);
        }
    }

    private Invocation getMBeanInvocation(org.jboss.wsf.spi.invocation.Invocation inv) {
        MessageContext msgContext = (MessageContext)inv.getInvocationContext().getAttachment(MessageContext.class);
        if (msgContext == null) {
            throw new IllegalStateException("Cannot obtain MessageContext");
        }
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        SecurityAdaptor securityAdaptor = ((SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class)).newSecurityAdapter();
        Principal principal = securityAdaptor.getPrincipal();
        Object credential = securityAdaptor.getCredential();
        Method method = inv.getJavaMethod();
        Object[] args = inv.getArgs();
        Invocation jbInv = new Invocation(null, method, args, null, principal, credential);
        HandlerCallback callback = (HandlerCallback)inv.getInvocationContext().getAttachment(HandlerCallback.class);
        if (callback == null) {
            throw new IllegalStateException("Cannot obtain HandlerCallback");
        }
        jbInv.setValue((Object)InvocationKey.SOAP_MESSAGE_CONTEXT, (Object)msgContext);
        jbInv.setValue((Object)InvocationKey.SOAP_MESSAGE, (Object)((SOAPMessageContext)msgContext).getMessage());
        jbInv.setType(InvocationType.SERVICE_ENDPOINT);
        jbInv.setValue((Object)HandlerCallback.class.getName(), (Object)callback, PayloadKey.TRANSIENT);
        jbInv.setValue((Object)org.jboss.wsf.spi.invocation.Invocation.class.getName(), (Object)inv, PayloadKey.TRANSIENT);
        return jbInv;
    }
}

