/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.container.jboss42;

import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.DeploymentException;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

/**
 * @author Heiko.Braun@jboss.com
 */
public class JAXWSDeployerHookPostJSE extends DeployerHookPostJSE
{


   public void deploy(DeploymentInfo unit) throws DeploymentException
   {
      if (ignoreDeployment(unit))
         return;

      if (!ignoreDeployment(unit) && isWebServiceDeployment(unit))
      {
         log.debug("deploy: " + unit.shortName);
         Deployment dep = getDeployment(unit);

         if (null == dep || Deployment.DeploymentState.CREATED != dep.getState())
            throw new DeploymentException("Create step failed");
       
         getRuntime().start(dep);                  
      }
   }

   /** Get the deployment type this deployer can handle
    */
   public Deployment.DeploymentType getDeploymentType()
   {
      return Deployment.DeploymentType.JAXWS_JSE;
   }

   /**
    * Reject JAX-RPC deployments
    */
   @Override
   public boolean isWebServiceDeployment(DeploymentInfo unit)
   {
      WebservicesMetaData wsMetaData = getWebservicesMetaData(unit, "WEB-INF/webservices.xml"); // JAX-RPC artifact
      return (wsMetaData == null && super.isWebServiceDeployment(unit));
   }
}
