/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.container.jboss42.AbstractDeployerHook;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.metadata.webservices.WebservicesFactory;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.w3c.dom.Element;

public abstract class ArchiveDeployerHook
extends AbstractDeployerHook {
    public abstract Deployment.DeploymentType getDeploymentType();

    public abstract boolean isWebServiceDeployment(DeploymentInfo var1);

    public abstract Deployment createDeployment(DeploymentInfo var1);

    public Deployment getDeployment(DeploymentInfo unit) {
        Deployment dep = (Deployment)unit.context.get(Deployment.class);
        return dep != null && dep.getType() == this.getDeploymentType() ? dep : null;
    }

    public void deploy(DeploymentInfo unit) throws DeploymentException {
        if (this.ignoreDeployment(unit)) {
            return;
        }
        if (this.isWebServiceDeployment(unit)) {
            this.log.debug((Object)("deploy: " + unit.shortName));
            Deployment dep = this.getDeployment(unit);
            if (dep == null) {
                dep = this.createDeployment(unit);
                dep.addAttachment(DeploymentInfo.class, (Object)unit);
            }
            this.getRuntime().create(dep);
            unit.context.put(Deployment.class, dep);
        }
    }

    public void undeploy(DeploymentInfo unit) {
        if (this.ignoreDeployment(unit)) {
            return;
        }
        Deployment dep = this.getDeployment(unit);
        if (dep != null) {
            this.log.debug((Object)("undeploy: " + unit.shortName));
            this.getRuntime().stop(dep);
            this.getRuntime().destroy(dep);
        }
    }

    protected WebservicesMetaData getWebservicesMetaData(DeploymentInfo unit, String wsFile) {
        WebservicesMetaData wsMetaData = (WebservicesMetaData)unit.context.get(WebservicesMetaData.class);
        UnifiedVirtualFile vfWebservices = this.getWebservicesFile(unit, wsFile);
        if (wsMetaData == null && vfWebservices != null) {
            try {
                URL wsURL = vfWebservices.toURL();
                Element root = DOMUtils.parse((InputStream)wsURL.openStream());
                String namespaceURI = root.getNamespaceURI();
                if (namespaceURI.equals("http://java.sun.com/xml/ns/j2ee")) {
                    Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                    WebservicesFactory factory = new WebservicesFactory(wsURL);
                    wsMetaData = (WebservicesMetaData)unmarshaller.unmarshal(wsURL.openStream(), (ObjectModelFactory)factory, null);
                    unit.context.put(WebservicesMetaData.class, wsMetaData);
                }
            }
            catch (Exception ex) {
                throw new WSFDeploymentException((Throwable)ex);
            }
        }
        return wsMetaData;
    }

    private UnifiedVirtualFile getWebservicesFile(DeploymentInfo unit, String wsFile) {
        try {
            ResourceLoaderAdapter vfsRoot = new ResourceLoaderAdapter((ClassLoader)unit.localCl);
            return wsFile != null ? vfsRoot.findChild(wsFile) : null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

