/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployment.metadata;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossGenericBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.WebservicesMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.javaee.spec.PortComponent;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.SLSBMetaData;

public class EJBArchiveMetaDataAdapterEJB3 {
    private static Logger log = Logger.getLogger(EJBArchiveMetaDataAdapterEJB3.class);

    public EJBArchiveMetaData buildMetaData(Deployment dep, DeploymentUnit unit) {
        Ejb3Deployment ejb3Deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
        dep.addAttachment(Ejb3Deployment.class, (Object)ejb3Deployment);
        EJBArchiveMetaData umd = new EJBArchiveMetaData();
        this.buildEnterpriseBeansMetaData(umd, ejb3Deployment);
        JBossMetaData jbMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        if (jbMetaData != null) {
            this.buildWebservicesMetaData(umd, jbMetaData);
        }
        return umd;
    }

    private void buildWebservicesMetaData(EJBArchiveMetaData ejbMetaData, JBossMetaData jbMetaData) {
        WebservicesMetaData wsMetaData = jbMetaData.getWebservices();
        if (wsMetaData != null) {
            String contextRoot = wsMetaData.getContextRoot();
            ejbMetaData.setWebServiceContextRoot(contextRoot);
            ejbMetaData.setPublishLocationAdapter(this.getPublishLocationAdpater(wsMetaData));
            WebserviceDescriptionsMetaData wsDescriptions = wsMetaData.getWebserviceDescriptions();
            if (wsDescriptions != null) {
                if (wsDescriptions.size() > 1) {
                    log.warn((Object)"Multiple <webservice-description> elements not supported");
                }
                if (wsDescriptions.size() > 0) {
                    WebserviceDescriptionMetaData wsd = (WebserviceDescriptionMetaData)wsDescriptions.iterator().next();
                    ejbMetaData.setConfigName(wsd.getConfigName());
                    ejbMetaData.setConfigFile(wsd.getConfigFile());
                }
            }
        }
    }

    private void buildEnterpriseBeansMetaData(EJBArchiveMetaData jarMetaData, Ejb3Deployment ejb3Deployment) {
        ArrayList<SLSBMetaData> ejbMetaDataList = new ArrayList<SLSBMetaData>();
        for (EJBContainer container : ejb3Deployment.getEjbContainers().values()) {
            SLSBMetaData ejbMetaData = null;
            PortComponent pcMetaData = null;
            if (container instanceof StatelessContainer) {
                ejbMetaData = new SLSBMetaData();
                JBossEnterpriseBeanMetaData beanMetaData = container.getXml();
                if (beanMetaData instanceof JBossGenericBeanMetaData) {
                    pcMetaData = ((JBossGenericBeanMetaData)beanMetaData).getPortComponent();
                } else if (beanMetaData instanceof JBossSessionBeanMetaData) {
                    pcMetaData = ((JBossSessionBeanMetaData)beanMetaData).getPortComponent();
                }
            } else if (container instanceof MessagingContainer) {
                ActivationConfigPropertyMetaData destProp;
                ejbMetaData = new MDBMetaData();
                MessagingContainer mdb = (MessagingContainer)container;
                Map props = mdb.getActivationConfigProperties();
                if (props != null && (destProp = (ActivationConfigPropertyMetaData)props.get("destination")) != null) {
                    String destination = destProp.getValue();
                    ((MDBMetaData)ejbMetaData).setDestinationJndiName(destination);
                }
            }
            if (ejbMetaData == null) continue;
            ejbMetaData.setEjbName(container.getEjbName());
            ejbMetaData.setEjbClass(container.getBeanClassName());
            if (pcMetaData != null) {
                ejbMetaData.setPortComponentName(pcMetaData.getPortComponentName());
                ejbMetaData.setPortComponentURI(pcMetaData.getPortComponentURI());
                EJBSecurityMetaData smd = new EJBSecurityMetaData();
                smd.setAuthMethod(pcMetaData.getAuthMethod());
                smd.setTransportGuarantee(pcMetaData.getTransportGuarantee());
                smd.setSecureWSDLAccess(Boolean.valueOf(pcMetaData.getSecureWSDLAccess()));
                ejbMetaData.setSecurityMetaData(smd);
            }
            ejbMetaDataList.add(ejbMetaData);
        }
        jarMetaData.setEnterpriseBeans(ejbMetaDataList);
    }

    private EJBArchiveMetaData.PublishLocationAdapter getPublishLocationAdpater(final WebservicesMetaData wsMetaData) {
        return new EJBArchiveMetaData.PublishLocationAdapter(){

            public String getWsdlPublishLocationByName(String name) {
                String wsdlPublishLocation = null;
                WebserviceDescriptionsMetaData wsDescriptions = wsMetaData.getWebserviceDescriptions();
                if (wsDescriptions != null && wsDescriptions.get(name) != null) {
                    WebserviceDescriptionMetaData wsdMetaData = (WebserviceDescriptionMetaData)wsDescriptions.get(name);
                    wsdlPublishLocation = wsdMetaData.getWsdlPublishLocation();
                }
                return wsdlPublishLocation;
            }
        };
    }
}

