/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.deployers;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.EjbDeployment;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.webservices.integration.util.ASHelper;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public final class WSEJBAdapterDeployer
extends AbstractRealDeployer {
    public WSEJBAdapterDeployer() {
        this.addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        this.addInput(EjbDeployment.class);
        this.addInput(Ejb3Deployment.class);
        this.addInput(WebservicesMetaData.class);
        this.addOutput(WebServiceDeployment.class);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        JBossMetaData mergedMD = (JBossMetaData)unit.getAttachment(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        Ejb3Deployment ejb3Deployment = ASHelper.getOptionalAttachment(unit, Ejb3Deployment.class);
        if (mergedMD != null) {
            WebServiceDeploymentAdapter wsDeploymentAdapter = new WebServiceDeploymentAdapter();
            List<WebServiceDeclaration> endpoints = wsDeploymentAdapter.getServiceEndpoints();
            for (JBossEnterpriseBeanMetaData ejbMD : mergedMD.getEnterpriseBeans()) {
                String ejbName = ejbMD.determineContainerName();
                if (ejbMD.getEjbClass() != null) {
                    this.log.debug((Object)("Creating webservice EJB adapter for: " + ejbName));
                    EJBContainer ejbContainer = this.getContainer(ejb3Deployment, ejbMD);
                    endpoints.add(new WebServiceDeclarationAdapter(ejbMD, ejbContainer, unit.getClassLoader()));
                    continue;
                }
                this.log.warn((Object)("Ingoring EJB deployment with null classname: " + ejbName));
            }
            unit.addAttachment(WebServiceDeployment.class, (Object)wsDeploymentAdapter);
        }
    }

    private EJBContainer getContainer(Ejb3Deployment ejb3Deployment, JBossEnterpriseBeanMetaData ejbMD) throws DeploymentException {
        if (ejb3Deployment != null && !ejbMD.isEntity()) {
            try {
                ObjectName objName = new ObjectName(ejbMD.determineContainerName());
                return (EJBContainer)ejb3Deployment.getContainer(objName);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        return null;
    }

    private static final class WebServiceDeploymentAdapter
    implements WebServiceDeployment {
        private final List<WebServiceDeclaration> endpoints = new ArrayList<WebServiceDeclaration>();

        private WebServiceDeploymentAdapter() {
        }

        public List<WebServiceDeclaration> getServiceEndpoints() {
            return this.endpoints;
        }
    }

    private static final class WebServiceDeclarationAdapter
    implements WebServiceDeclaration {
        private final JBossEnterpriseBeanMetaData ejbMetaData;
        private final EJBContainer ejbContainer;
        private final ClassLoader loader;

        private WebServiceDeclarationAdapter(JBossEnterpriseBeanMetaData ejbMetaData, EJBContainer ejbContainer, ClassLoader loader) {
            this.ejbMetaData = ejbMetaData;
            this.ejbContainer = ejbContainer;
            this.loader = loader;
        }

        public String getContainerName() {
            return this.ejbMetaData.determineContainerName();
        }

        public Context getContext() {
            return this.ejbContainer.getEnc();
        }

        public String getComponentName() {
            return this.ejbMetaData.getName();
        }

        public String getComponentClassName() {
            return this.ejbMetaData.getEjbClass();
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            boolean haveEjbContainer;
            boolean bl = haveEjbContainer = this.ejbContainer != null;
            if (haveEjbContainer) {
                return (T)this.ejbContainer.getAnnotation(annotationType);
            }
            Class<?> bean = this.getComponentClass();
            return bean.getAnnotation(annotationType);
        }

        private Class<?> getComponentClass() {
            try {
                return this.loader.loadClass(this.getComponentClassName());
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failed to load component class: " + this.getComponentClassName() + " from loader: " + this.loader);
            }
        }
    }
}

