/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss60.transport;

import javax.xml.ws.WebServiceException;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.wsf.container.jboss60.deployment.tomcat.WebMetaDataModifier;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

public class DynamicEndpointDeploymentAspect
extends DeploymentAspect {
    private static Logger log = Logger.getLogger(DynamicEndpointDeploymentAspect.class);
    private DeploymentFactory factory = new DeploymentFactory();
    private WebMetaDataModifier webMetaDataModifier;
    private DeployerClient mainDeployer;

    public void setWebMetaDataModifier(WebMetaDataModifier webMetaDataModifier) {
        this.webMetaDataModifier = webMetaDataModifier;
    }

    public void setMainDeployer(DeployerClient mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public void create(org.jboss.wsf.spi.deployment.Deployment dep) {
        JBossWebMetaData jbwmd = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (jbwmd == null) {
            throw new WebServiceException("Cannot find web meta data");
        }
        try {
            this.webMetaDataModifier.modifyMetaData(dep);
            AbstractDeployment deployment = this.createSimpleDeployment(dep.getService().getContextRoot());
            MutableAttachments mutableAttachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
            mutableAttachments.addAttachment("org.jboss.ws.generated.webapp", (Object)Boolean.TRUE);
            mutableAttachments.addAttachment(ClassLoaderFactory.class, (Object)new ContextClassLoaderFactory());
            mutableAttachments.addAttachment(JBossWebMetaData.class, (Object)jbwmd);
            this.mainDeployer.deploy(new Deployment[]{deployment});
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    public void destroy(org.jboss.wsf.spi.deployment.Deployment dep) {
        try {
            AbstractDeployment deployment = this.createSimpleDeployment(dep.getService().getContextRoot());
            this.mainDeployer.undeploy(new Deployment[]{deployment});
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    private AbstractDeployment createSimpleDeployment(String name) {
        AbstractDeployment unit = new AbstractDeployment(name);
        this.factory.addContext((PredeterminedManagedObjectAttachments)unit, "");
        return unit;
    }

    private static class ContextClassLoaderFactory
    implements ClassLoaderFactory {
        private ContextClassLoaderFactory() {
        }

        public ClassLoader createClassLoader(DeploymentUnit unit) throws Exception {
            return Thread.currentThread().getContextClassLoader();
        }

        public void removeClassLoader(DeploymentUnit unit) throws Exception {
        }
    }
}

