/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.tomcat;

import java.util.HashSet;
import java.util.List;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WebMetaDataHelper;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.WSFServlet;

final class WebMetaDataModifier {
    private final Logger log = Logger.getLogger(WebMetaDataModifier.class);

    WebMetaDataModifier() {
    }

    void modify(Deployment dep) {
        JBossWebMetaData jbossWebMD = (JBossWebMetaData)WSHelper.getOptionalAttachment((Deployment)dep, JBossWebMetaData.class);
        if (jbossWebMD != null) {
            this.configureEndpoints(dep, jbossWebMD);
            this.modifyContextRoot(dep, jbossWebMD);
        }
    }

    private void configureEndpoints(Deployment dep, JBossWebMetaData jbossWebMD) {
        String transportClassName = this.getTransportClassName(dep);
        this.log.trace((Object)"Modifying servlets");
        HashSet<String> epNames = new HashSet<String>();
        for (Endpoint ep : dep.getService().getEndpoints()) {
            epNames.add(ep.getTargetBeanName());
        }
        for (JBossServletMetaData servletMD : jbossWebMD.getServlets()) {
            String endpointClassName = ASHelper.getEndpointName((ServletMetaData)servletMD);
            if (endpointClassName == null || endpointClassName.length() <= 0 || !epNames.contains(endpointClassName)) continue;
            servletMD.setServletClass(WSFServlet.class.getName());
            this.log.debug((Object)("Setting transport class: " + transportClassName + " for servlet: " + endpointClassName));
            List<ParamValueMetaData> initParams = WebMetaDataHelper.getServletInitParams((ServletMetaData)servletMD);
            WebMetaDataHelper.newParamValue("org.jboss.wsf.spi.deployment.stackServletDelegateClass", transportClassName, initParams);
            WebMetaDataHelper.newParamValue("jboss.ws.endpoint", endpointClassName, initParams);
        }
    }

    private void modifyContextRoot(Deployment dep, JBossWebMetaData jbossWebMD) {
        String contextRoot = dep.getService().getContextRoot();
        this.log.debug((Object)("Setting context root: " + contextRoot + " for deployment: " + dep.getSimpleName()));
        jbossWebMD.setContextRoot(contextRoot);
    }

    private String getTransportClassName(Deployment dep) {
        String transportClassName = (String)dep.getProperty("stack.transport.class");
        if (transportClassName == null) {
            throw new IllegalStateException("Cannot obtain deployment property : stack.transport.class");
        }
        return transportClassName;
    }
}

