/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;

final class WSSubsystemDescribe
implements OperationStepHandler {
    static final WSSubsystemDescribe INSTANCE = new WSSubsystemDescribe();

    private WSSubsystemDescribe() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode wsSubsystemAddress = rootAddress.toModelNode();
        ModelNode wsSubsystem = context.readModel(PathAddress.EMPTY_ADDRESS);
        ModelNode result = context.getResult();
        ModelNode subsystemAdd = WSSubsystemDescribe.getSubsystemAddOperation(wsSubsystemAddress, wsSubsystem);
        result.add(subsystemAdd);
        if (wsSubsystem.hasDefined("endpoint-config")) {
            ModelNode endpointConfigs = wsSubsystem.get("endpoint-config");
            for (String configName : endpointConfigs.keys()) {
                ModelNode handlerAdd;
                ModelNode handlerAddress;
                ModelNode handler;
                ModelNode handlers;
                ModelNode endpointConfig = endpointConfigs.get(configName);
                ModelNode endpointConfigAddress = wsSubsystemAddress.clone().add("endpoint-config", configName);
                ModelNode endpointConfigAdd = WSSubsystemDescribe.getEndpointConfigAddOperation(endpointConfigAddress);
                result.add(endpointConfigAdd);
                if (endpointConfig.hasDefined("pre-handler-chain")) {
                    ModelNode preHandlerChains = endpointConfig.get("pre-handler-chain");
                    for (String preHandlerChainName : preHandlerChains.keys()) {
                        ModelNode preHandlerChain = preHandlerChains.get(preHandlerChainName);
                        ModelNode preHandlerChainAddress = endpointConfigAddress.clone().add("pre-handler-chain", preHandlerChainName);
                        ModelNode preHandlerChainAdd = WSSubsystemDescribe.getHandlerChainAddOperation(preHandlerChainAddress, preHandlerChain);
                        result.add(preHandlerChainAdd);
                        if (!preHandlerChain.hasDefined("handler")) continue;
                        handlers = preHandlerChain.get("handler");
                        for (String handlerName : handlers.keys()) {
                            handler = handlers.get(handlerName);
                            handlerAddress = preHandlerChainAddress.clone().add("handler", handlerName);
                            handlerAdd = WSSubsystemDescribe.getHandlerAddOperation(handlerAddress, handler);
                            result.add(handlerAdd);
                        }
                    }
                }
                if (endpointConfig.hasDefined("post-handler-chain")) {
                    ModelNode postHandlerChains = endpointConfig.get("post-handler-chain");
                    for (String postHandlerChainName : postHandlerChains.keys()) {
                        ModelNode postHandlerChain = postHandlerChains.get(postHandlerChainName);
                        ModelNode postHandlerChainAddress = endpointConfigAddress.clone().add("post-handler-chain", postHandlerChainName);
                        ModelNode postHandlerChainAdd = WSSubsystemDescribe.getHandlerChainAddOperation(postHandlerChainAddress, postHandlerChain);
                        result.add(postHandlerChainAdd);
                        if (!postHandlerChain.hasDefined("handler")) continue;
                        handlers = postHandlerChain.get("handler");
                        for (String handlerName : handlers.keys()) {
                            handler = handlers.get(handlerName);
                            handlerAddress = postHandlerChainAddress.clone().add("handler", handlerName);
                            handlerAdd = WSSubsystemDescribe.getHandlerAddOperation(handlerAddress, handler);
                            result.add(handlerAdd);
                        }
                    }
                }
                if (!endpointConfig.hasDefined("property")) continue;
                ModelNode properties = endpointConfig.get("property");
                for (String propertyName : properties.keys()) {
                    ModelNode property = properties.get(propertyName);
                    ModelNode propertyAddress = endpointConfigAddress.clone().add("property", propertyName);
                    ModelNode propertyAdd = WSSubsystemDescribe.getPropertyAddOperation(propertyAddress, property);
                    result.add(propertyAdd);
                }
            }
        }
        context.completeStep();
    }

    private static ModelNode getSubsystemAddOperation(ModelNode wsSubsystemAddress, ModelNode wsSubsystem) {
        ModelNode wsSubsystemAdd = new ModelNode();
        wsSubsystemAdd.get("operation").set("add");
        wsSubsystemAdd.get("address").set(wsSubsystemAddress);
        if (wsSubsystem.hasDefined("modify-wsdl-address")) {
            wsSubsystemAdd.get("modify-wsdl-address").set(wsSubsystem.get("modify-wsdl-address"));
        }
        if (wsSubsystem.hasDefined("wsdl-host")) {
            wsSubsystemAdd.get("wsdl-host").set(wsSubsystem.get("wsdl-host"));
        }
        if (wsSubsystem.hasDefined("wsdl-port")) {
            wsSubsystemAdd.get("wsdl-port").set(wsSubsystem.get("wsdl-port"));
        }
        if (wsSubsystem.hasDefined("wsdl-secure-port")) {
            wsSubsystemAdd.get("wsdl-secure-port").set(wsSubsystem.get("wsdl-secure-port"));
        }
        return wsSubsystemAdd;
    }

    private static ModelNode getEndpointConfigAddOperation(ModelNode endpointConfigAddress) {
        ModelNode endpointConfigAdd = new ModelNode();
        endpointConfigAdd.get("operation").set("add");
        endpointConfigAdd.get("address").set(endpointConfigAddress);
        return endpointConfigAdd;
    }

    private static ModelNode getPropertyAddOperation(ModelNode propertyAddress, ModelNode property) {
        ModelNode propertyAdd = new ModelNode();
        propertyAdd.get("operation").set("add");
        propertyAdd.get("address").set(propertyAddress);
        if (property.hasDefined("value")) {
            propertyAdd.get("value").set(property.get("value").asString());
        }
        return propertyAdd;
    }

    private static ModelNode getHandlerChainAddOperation(ModelNode handlerChainAddress, ModelNode handlerChain) {
        ModelNode handlerChainAdd = new ModelNode();
        handlerChainAdd.get("operation").set("add");
        handlerChainAdd.get("address").set(handlerChainAddress);
        if (handlerChain.hasDefined("protocol-bindings")) {
            handlerChainAdd.get("protocol-bindings").set(handlerChain.get("protocol-bindings").asString());
        }
        return handlerChainAdd;
    }

    private static ModelNode getHandlerAddOperation(ModelNode handlerAddress, ModelNode handler) {
        ModelNode handlerAdd = new ModelNode();
        handlerAdd.get("operation").set("add");
        handlerAdd.get("address").set(handlerAddress);
        if (handler.hasDefined("class")) {
            handlerAdd.get("class").set(handler.get("class").asString());
        }
        return handlerAdd;
    }
}

