/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.Map;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.publish.EndpointPublisherImpl;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.publish.Context;

public final class EndpointPublishService
implements Service<Context> {
    private final ServiceName name;
    private volatile Context wsctx;
    private final ClassLoader loader;
    private final String context;
    private final Map<String, String> urlPatternToClassName;
    private final JBossWebMetaData jbwmd;
    private final WebservicesMetaData wsmd;
    private final JBossWebservicesMetaData jbwsmd;
    private final InjectedValue<VirtualHost> hostInjector = new InjectedValue();

    private EndpointPublishService(String context, ClassLoader loader, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd) {
        this.name = WSServices.ENDPOINT_PUBLISH_SERVICE.append(new String[]{context});
        this.loader = loader;
        this.context = context;
        this.urlPatternToClassName = urlPatternToClassName;
        this.jbwmd = jbwmd;
        this.wsmd = wsmd;
        this.jbwsmd = jbwsmd;
    }

    public Context getValue() {
        return this.wsctx;
    }

    public ServiceName getName() {
        return this.name;
    }

    public InjectedValue<VirtualHost> getHostInjector() {
        return this.hostInjector;
    }

    public void start(StartContext ctx) throws StartException {
        WSLogger.ROOT_LOGGER.starting(this.name);
        try {
            EndpointPublisherImpl publisher = new EndpointPublisherImpl(((VirtualHost)this.hostInjector.getValue()).getHost(), true);
            this.wsctx = publisher.publish(ctx.getChildTarget(), this.context, this.loader, this.urlPatternToClassName, this.jbwmd, this.wsmd, this.jbwsmd);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext ctx) {
        WSLogger.ROOT_LOGGER.stopping(this.name);
        try {
            EndpointPublisherImpl publisher = new EndpointPublisherImpl(((VirtualHost)this.hostInjector.getValue()).getHost(), true);
            publisher.destroy(this.wsctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ServiceBuilder<Context> createServiceBuilder(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName) {
        return EndpointPublishService.createServiceBuilder(serviceTarget, context, loader, hostName, urlPatternToClassName, null, null, null);
    }

    public static ServiceBuilder<Context> createServiceBuilder(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd) {
        EndpointPublishService service = new EndpointPublishService(context, loader, urlPatternToClassName, jbwmd, wsmd, jbwsmd);
        ServiceBuilder builder = serviceTarget.addService(service.getName(), (Service)service);
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, WSServices.CONFIG_SERVICE);
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, WSServices.REGISTRY_SERVICE);
        builder.addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{hostName}), VirtualHost.class, service.getHostInjector());
        return builder;
    }

    public static void install(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName) {
        ServiceBuilder<Context> builder = EndpointPublishService.createServiceBuilder(serviceTarget, context, loader, hostName, urlPatternToClassName);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }
}

