/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.wsf.spi.management.ServerConfig;

final class WSSubsystemAttributeChangeHandler
extends AbstractWriteAttributeHandler<Void> {
    WSSubsystemAttributeChangeHandler(AttributeDefinition ... definitions) {
        super(definitions);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandback) throws OperationFailedException {
        ServiceController configService = context.getServiceRegistry(true).getService(WSServices.CONFIG_SERVICE);
        if (configService != null) {
            String value;
            ServerConfig config = (ServerConfig)configService.getValue();
            String string = value = resolvedValue.isDefined() ? resolvedValue.asString() : null;
            if ("modify-wsdl-address".equals(attributeName)) {
                boolean modifyWSDLAddress = value != null && Boolean.parseBoolean(value);
                config.setModifySOAPAddress(modifyWSDLAddress);
            } else if ("wsdl-host".equals(attributeName)) {
                String host = value != null ? value : null;
                try {
                    config.setWebServiceHost(host);
                }
                catch (Exception e) {
                    throw new OperationFailedException(e.getMessage(), (Throwable)e);
                }
            } else if ("wsdl-port".equals(attributeName)) {
                int port = value != null ? Integer.parseInt(value) : -1;
                config.setWebServicePort(port);
            } else if ("wsdl-secure-port".equals(attributeName)) {
                int securePort = value != null ? Integer.parseInt(value) : -1;
                config.setWebServiceSecurePort(securePort);
            }
        }
        return true;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
    }
}

