/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;

final class PropertyAdd
extends AbstractAddStepHandler {
    static final PropertyAdd INSTANCE = new PropertyAdd();

    private PropertyAdd() {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        super.rollbackRuntime(context, operation, model, controllers);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServerConfig config = PackageUtils.getServerConfig(context);
        if (config != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String propertyName = address.getElement(address.size() - 1).getValue();
            PathElement confElem = address.getElement(address.size() - 2);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            String propertyValue = operation.has("value") ? Attributes.VALUE.resolveModelAttribute(context, operation).asString() : null;
            for (CommonConfig commonConfig : PackageUtils.getConfigs(config, configType)) {
                if (!configName.equals(commonConfig.getConfigName())) continue;
                commonConfig.setProperty(propertyName, propertyValue);
                if (!context.isBooting()) {
                    context.reloadRequired();
                }
                return;
            }
            throw WSMessages.MESSAGES.missingConfig(configName);
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        Attributes.VALUE.validateAndSet(operation, model);
    }
}

