/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.tomcat;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.tomcat.SecurityMetaDataAccessorEJB;
import org.jboss.as.webservices.tomcat.SecurityMetaDataAccessorEJB21;
import org.jboss.as.webservices.tomcat.SecurityMetaDataAccessorEJB3;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WebMetaDataHelper;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.merge.javaee.spec.SecurityRolesMetaDataMerger;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.HttpEndpoint;

final class WebMetaDataCreator {
    private static final String EJB_WEBSERVICE_REALM = "EJBWebServiceEndpointServlet Realm";
    private final SecurityMetaDataAccessorEJB ejb21SecurityAccessor = new SecurityMetaDataAccessorEJB21();
    private final SecurityMetaDataAccessorEJB ejb3SecurityAccessor = new SecurityMetaDataAccessorEJB3();

    WebMetaDataCreator() {
    }

    void create(Deployment dep) {
        JBossWebMetaData jbossWebMD;
        DeploymentUnit unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class);
        WarMetaData warMD = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData jBossWebMetaData = jbossWebMD = warMD != null ? warMD.getMergedJBossWebMetaData() : null;
        if (warMD == null) {
            warMD = new WarMetaData();
        }
        if (jbossWebMD == null) {
            jbossWebMD = new JBossWebMetaData();
            warMD.setMergedJBossWebMetaData(jbossWebMD);
            unit.putAttachment(WarMetaData.ATTACHMENT_KEY, (Object)warMD);
        }
        this.createWebAppDescriptor(dep, jbossWebMD);
        this.createJBossWebAppDescriptor(dep, jbossWebMD);
        dep.addAttachment(JBossWebMetaData.class, (Object)jbossWebMD);
    }

    private void createWebAppDescriptor(Deployment dep, JBossWebMetaData jbossWebMD) {
        WSLogger.ROOT_LOGGER.creatingWebXmlDescriptor();
        this.createServlets(dep, jbossWebMD);
        this.createServletMappings(dep, jbossWebMD);
        this.createSecurityConstraints(dep, jbossWebMD);
        this.createLoginConfig(dep, jbossWebMD);
        this.createSecurityRoles(dep, jbossWebMD);
    }

    private void createJBossWebAppDescriptor(Deployment dep, JBossWebMetaData jbossWebMD) {
        String virtualHost;
        boolean hasSecurityDomain;
        WSLogger.ROOT_LOGGER.creatingJBossWebXmlDescriptor();
        SecurityMetaDataAccessorEJB ejbMDAccessor = this.getEjbSecurityMetaDataAccessor(dep);
        String securityDomain = ejbMDAccessor.getSecurityDomain(dep);
        boolean bl = hasSecurityDomain = securityDomain != null;
        if (hasSecurityDomain) {
            WSLogger.ROOT_LOGGER.settingSecurityDomain(securityDomain);
            jbossWebMD.setSecurityDomain(securityDomain);
        }
        if ((virtualHost = dep.getService().getVirtualHost()) != null) {
            WSLogger.ROOT_LOGGER.settingVirtualHost(virtualHost);
            jbossWebMD.setVirtualHosts(Arrays.asList(virtualHost));
        }
    }

    private void createServlets(Deployment dep, JBossWebMetaData jbossWebMD) {
        WSLogger.ROOT_LOGGER.creatingServlets();
        JBossServletsMetaData servlets = WebMetaDataHelper.getServlets(jbossWebMD);
        for (Endpoint endpoint : dep.getService().getEndpoints()) {
            String endpointName = endpoint.getShortName();
            String endpointClassName = endpoint.getTargetBeanName();
            WSLogger.ROOT_LOGGER.creatingServlet(endpointName, endpointClassName);
            WebMetaDataHelper.newServlet(endpointName, endpointClassName, servlets);
        }
    }

    private void createServletMappings(Deployment dep, JBossWebMetaData jbossWebMD) {
        WSLogger.ROOT_LOGGER.creatingServletMappings();
        List<ServletMappingMetaData> servletMappings = WebMetaDataHelper.getServletMappings(jbossWebMD);
        for (Endpoint ep : dep.getService().getEndpoints()) {
            if (!(ep instanceof HttpEndpoint)) continue;
            String endpointName = ep.getShortName();
            List<String> urlPatterns = WebMetaDataHelper.getUrlPatterns(((HttpEndpoint)ep).getURLPattern());
            WSLogger.ROOT_LOGGER.creatingServletMapping(endpointName, urlPatterns);
            WebMetaDataHelper.newServletMapping(endpointName, urlPatterns, servletMappings);
        }
    }

    private void createSecurityConstraints(Deployment dep, JBossWebMetaData jbossWebMD) {
        WSLogger.ROOT_LOGGER.creatingSecurityConstraints();
        SecurityMetaDataAccessorEJB ejbMDAccessor = this.getEjbSecurityMetaDataAccessor(dep);
        for (Endpoint ejbEndpoint : dep.getService().getEndpoints()) {
            boolean hasAuthMethod;
            boolean secureWsdlAccess = ejbMDAccessor.isSecureWsdlAccess(ejbEndpoint);
            String transportGuarantee = ejbMDAccessor.getTransportGuarantee(ejbEndpoint);
            boolean hasTransportGuarantee = transportGuarantee != null;
            String authMethod = ejbMDAccessor.getAuthMethod(ejbEndpoint);
            boolean bl = hasAuthMethod = authMethod != null;
            if (!(ejbEndpoint instanceof HttpEndpoint) || !hasAuthMethod && !hasTransportGuarantee) continue;
            List<SecurityConstraintMetaData> securityConstraints = WebMetaDataHelper.getSecurityConstraints(jbossWebMD);
            SecurityConstraintMetaData securityConstraint = WebMetaDataHelper.newSecurityConstraint(securityConstraints);
            WebResourceCollectionsMetaData webResourceCollections = WebMetaDataHelper.getWebResourceCollections(securityConstraint);
            String endpointName = ejbEndpoint.getShortName();
            String urlPattern = ((HttpEndpoint)ejbEndpoint).getURLPattern();
            WSLogger.ROOT_LOGGER.creatingWebResourceCollection(endpointName, urlPattern);
            WebMetaDataHelper.newWebResourceCollection(endpointName, urlPattern, secureWsdlAccess, webResourceCollections);
            if (hasAuthMethod) {
                WSLogger.ROOT_LOGGER.creatingAuthConstraint(endpointName);
                WebMetaDataHelper.newAuthConstraint(WebMetaDataHelper.getAllRoles(), securityConstraint);
            }
            if (!hasTransportGuarantee) continue;
            WSLogger.ROOT_LOGGER.creatingUserDataConstraint(endpointName, transportGuarantee);
            WebMetaDataHelper.newUserDataConstraint(transportGuarantee, securityConstraint);
        }
    }

    private void createLoginConfig(Deployment dep, JBossWebMetaData jbossWebMD) {
        boolean hasAuthMethod;
        String authMethod = this.getAuthMethod(dep);
        boolean bl = hasAuthMethod = authMethod != null;
        if (hasAuthMethod) {
            WSLogger.ROOT_LOGGER.creatingLoginConfig(EJB_WEBSERVICE_REALM, authMethod);
            LoginConfigMetaData loginConfig = WebMetaDataHelper.getLoginConfig(jbossWebMD);
            loginConfig.setRealmName(EJB_WEBSERVICE_REALM);
            loginConfig.setAuthMethod(authMethod);
        }
    }

    private void createSecurityRoles(Deployment dep, JBossWebMetaData jbossWebMD) {
        EarMetaData earMetaData;
        DeploymentUnit unit;
        DeploymentUnit parent;
        boolean hasAuthMethod;
        String authMethod = this.getAuthMethod(dep);
        boolean bl = hasAuthMethod = authMethod != null;
        if (hasAuthMethod) {
            boolean hasSecurityRolesMD;
            SecurityMetaDataAccessorEJB ejbMDAccessor = this.getEjbSecurityMetaDataAccessor(dep);
            SecurityRolesMetaData securityRolesMD = ejbMDAccessor.getSecurityRoles(dep);
            boolean bl2 = hasSecurityRolesMD = securityRolesMD != null && !securityRolesMD.isEmpty();
            if (hasSecurityRolesMD) {
                WSLogger.ROOT_LOGGER.creatingSecurityRoles();
                jbossWebMD.setSecurityRoles(securityRolesMD);
            }
        }
        if ((parent = (unit = (DeploymentUnit)dep.getAttachment(DeploymentUnit.class)).getParent()) != null && (earMetaData = (EarMetaData)parent.getAttachment(Attachments.EAR_METADATA)) != null) {
            SecurityRolesMetaData earSecurityRolesMetaData;
            if (jbossWebMD.getSecurityRoles() == null) {
                jbossWebMD.setSecurityRoles(new SecurityRolesMetaData());
            }
            if ((earSecurityRolesMetaData = earMetaData.getSecurityRoles()) != null) {
                SecurityRolesMetaDataMerger.merge((SecurityRolesMetaData)jbossWebMD.getSecurityRoles(), (SecurityRolesMetaData)jbossWebMD.getSecurityRoles(), (SecurityRolesMetaData)earSecurityRolesMetaData);
            }
        }
    }

    private String getAuthMethod(Deployment dep) {
        SecurityMetaDataAccessorEJB ejbMDAccessor = this.getEjbSecurityMetaDataAccessor(dep);
        for (Endpoint ejbEndpoint : dep.getService().getEndpoints()) {
            String beanAuthMethod = ejbMDAccessor.getAuthMethod(ejbEndpoint);
            boolean hasBeanAuthMethod = beanAuthMethod != null;
            if (!hasBeanAuthMethod) continue;
            return beanAuthMethod;
        }
        return null;
    }

    private SecurityMetaDataAccessorEJB getEjbSecurityMetaDataAccessor(Deployment dep) {
        boolean isJaxws = WSHelper.isJaxwsDeployment((Deployment)dep);
        return isJaxws ? this.ejb3SecurityAccessor : this.ejb21SecurityAccessor;
    }
}

