/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.io.IOException;
import java.net.URL;
import org.jboss.as.ee.structure.JBossDescriptorPropertyReplacement;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.metadata.WebservicesPropertyReplaceFactory;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public final class WebservicesDescriptorDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        URL webservicesDescriptorURL = this.getWebServicesDescriptorURL(deploymentRoot);
        if (webservicesDescriptorURL != null) {
            WebservicesPropertyReplaceFactory webservicesFactory = new WebservicesPropertyReplaceFactory(webservicesDescriptorURL, JBossDescriptorPropertyReplacement.propertyReplacer((DeploymentUnit)unit));
            WebservicesMetaData webservicesMD = webservicesFactory.load(webservicesDescriptorURL);
            unit.putAttachment(WSAttachmentKeys.WEBSERVICES_METADATA_KEY, (Object)webservicesMD);
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }

    private URL getWebServicesDescriptorURL(ResourceRoot deploymentRoot) throws DeploymentUnitProcessingException {
        VirtualFile wsdd = deploymentRoot.getRoot().getChild("WEB-INF/webservices.xml");
        if (!wsdd.exists()) {
            wsdd = deploymentRoot.getRoot().getChild("META-INF/webservices.xml");
        }
        try {
            return wsdd.exists() ? wsdd.toURL() : null;
        }
        catch (IOException e) {
            throw WSMessages.MESSAGES.cannotGetURLForDescriptor(e, wsdd.getPathName());
        }
    }
}

