/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.WSMessages;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public final class VirtualFileAdaptor
implements UnifiedVirtualFile {
    private static final long serialVersionUID = -4509594124653184349L;
    private transient VirtualFile file;

    public VirtualFileAdaptor(VirtualFile file) {
        this.file = file;
    }

    private VirtualFile getFile() throws IOException {
        return this.file;
    }

    private UnifiedVirtualFile findChild(String child, boolean throwExceptionIfNotFound) throws IOException {
        VirtualFile virtualFile = this.getFile();
        VirtualFile childFile = this.file.getChild(child);
        if (!childFile.exists()) {
            if (throwExceptionIfNotFound) {
                throw WSMessages.MESSAGES.missingChild(child, virtualFile);
            }
            if (WSLogger.ROOT_LOGGER.isTraceEnabled()) {
                WSLogger.ROOT_LOGGER.missingChild(child, virtualFile);
            }
            return null;
        }
        return new VirtualFileAdaptor(childFile);
    }

    public UnifiedVirtualFile findChild(String child) throws IOException {
        return this.findChild(child, true);
    }

    public UnifiedVirtualFile findChildFailSafe(String child) {
        try {
            return this.findChild(child, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public URL toURL() {
        try {
            return this.getFile().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<UnifiedVirtualFile> getChildren() throws IOException {
        List vfList = this.getFile().getChildren();
        if (vfList == null) {
            return null;
        }
        LinkedList<UnifiedVirtualFile> uvfList = new LinkedList<UnifiedVirtualFile>();
        for (VirtualFile vf : vfList) {
            uvfList.add(new VirtualFileAdaptor(vf));
        }
        return uvfList;
    }

    public String getName() {
        try {
            return this.getFile().getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

