/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.injection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionMetaData {
    private final String targetClass;
    private final String targetName;
    private final Class<?> valueClass;
    private final String envEntryName;
    private final boolean isValueSpecified;
    private String toString;

    public InjectionMetaData(String targetClass, String targetName, String valueClass, String envEntryName, boolean isValueSpecified) {
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass not specified");
        }
        if (targetName == null) {
            throw new IllegalArgumentException("targetName not specified");
        }
        if (envEntryName == null) {
            throw new IllegalArgumentException("envEntryName not specified");
        }
        this.targetClass = targetClass;
        this.targetName = targetName;
        this.envEntryName = envEntryName;
        this.valueClass = this.valueOf(valueClass);
        this.isValueSpecified = isValueSpecified;
    }

    private Class<?> valueOf(String s) {
        if (s == null || s.trim().equals("")) {
            return null;
        }
        if (Boolean.class.getName().equals(s)) {
            return Boolean.class;
        }
        if (Byte.class.getName().equals(s)) {
            return Byte.class;
        }
        if (Character.class.getName().equals(s)) {
            return Character.class;
        }
        if (String.class.getName().equals(s)) {
            return String.class;
        }
        if (Short.class.getName().equals(s)) {
            return Short.class;
        }
        if (Integer.class.getName().equals(s)) {
            return Integer.class;
        }
        if (Long.class.getName().equals(s)) {
            return Long.class;
        }
        if (Float.class.getName().equals(s)) {
            return Float.class;
        }
        if (Double.class.getName().equals(s)) {
            return Double.class;
        }
        throw new IllegalArgumentException("Unsupported env entry type: " + s);
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String getEnvEntryName() {
        return this.envEntryName;
    }

    public boolean isEnvEntryValueSpecified() {
        return this.isValueSpecified;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('\n').append(this.getClass().getName()).append('@').append(this.hashCode());
            sb.append("\n{\n").append("   targetClass=").append(this.targetClass).append(",\n");
            sb.append("   targetName=").append(this.targetName).append(",\n");
            sb.append("   envEntryName=").append(this.envEntryName).append(",\n");
            sb.append("   envEntryType=").append(this.valueClass).append(",\n");
            sb.append("   performInjection=").append(this.isValueSpecified).append("\n}");
            this.toString = sb.toString();
        }
        return this.toString;
    }
}

