/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.tools;

import java.io.File;
import java.io.PrintStream;
import org.jboss.wsf.spi.tools.SecurityActions;
import org.jboss.wsf.spi.tools.WSContractProviderFactory;
import org.jboss.wsf.spi.util.ServiceLoader;

public abstract class WSContractProvider {
    private static String DEFAULT_PROVIDER = "org.jboss.ws.tools.jaxws.impl.JBossWSProviderFactoryImpl";
    public static final String PROVIDER_PROPERTY = "org.jboss.wsf.spi.tools.ProviderFactoryImpl";

    protected WSContractProvider() {
    }

    public static WSContractProvider newInstance() {
        return WSContractProvider.newInstance(SecurityActions.getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSContractProvider newInstance(ClassLoader loader) {
        ClassLoader oldLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(loader);
            WSContractProviderFactory factory = (WSContractProviderFactory)ServiceLoader.loadService(PROVIDER_PROPERTY, DEFAULT_PROVIDER);
            WSContractProvider wSContractProvider = factory.createProvider(loader);
            return wSContractProvider;
        }
        finally {
            SecurityActions.setContextClassLoader(oldLoader);
        }
    }

    public abstract void setGenerateWsdl(boolean var1);

    public abstract void setExtension(boolean var1);

    public abstract void setGenerateSource(boolean var1);

    public abstract void setOutputDirectory(File var1);

    public abstract void setResourceDirectory(File var1);

    public abstract void setSourceDirectory(File var1);

    public abstract void setClassLoader(ClassLoader var1);

    public abstract void provide(String var1);

    public abstract void provide(Class<?> var1);

    public abstract void setMessageStream(PrintStream var1);
}

