/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.wsf.spi.Loggers;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.metadata.AbstractHandlerChainsMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;
import org.jboss.wsf.spi.metadata.config.Feature;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.util.StAXUtils;

public class ConfigMetaDataParser
extends AbstractHandlerChainsMetaDataParser {
    private ConfigMetaDataParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigRoot parse(URL url) throws IOException {
        InputStream is = null;
        try {
            is = url.openStream();
            ConfigRoot configRoot = ConfigMetaDataParser.parse(is);
            return configRoot;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static ConfigRoot parse(InputStream is) throws IOException {
        try {
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            return ConfigMetaDataParser.parse(xmlr);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public static ConfigRoot parse(XMLStreamReader reader) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        ConfigRoot configRoot = null;
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "jaxws-config")) {
                    ConfigMetaDataParser parser = new ConfigMetaDataParser();
                    configRoot = parser.parseConfigRoot(reader);
                    break;
                }
                throw Messages.MESSAGES.unexpectedElement("urn:jboss:jbossws-jaxws-config", reader.getLocalName());
            }
        }
        return configRoot;
    }

    private ConfigRoot parseConfigRoot(XMLStreamReader reader) throws XMLStreamException {
        ConfigRoot configRoot = new ConfigRoot();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "jaxws-config")) {
                        return configRoot;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "endpoint-config")) {
                        EndpointConfig epConfig = new EndpointConfig();
                        this.parseConfig(reader, epConfig, "endpoint-config");
                        configRoot.addEndpointConfig(epConfig);
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "client-config")) {
                        ClientConfig clConfig = new ClientConfig();
                        this.parseConfig(reader, clConfig, "client-config");
                        configRoot.addClientConfig(clConfig);
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private void parseConfig(XMLStreamReader reader, CommonConfig config, String configElement) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", configElement)) {
                        return;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    UnifiedHandlerChainsMetaData uhcmd;
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "config-name")) {
                        config.setConfigName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "pre-handler-chains")) {
                        uhcmd = this.parseHandlerChains(reader, "http://java.sun.com/xml/ns/javaee", "urn:jboss:jbossws-jaxws-config:4.0", "pre-handler-chains");
                        config.setPreHandlerChains(uhcmd.getHandlerChains());
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "post-handler-chains")) {
                        uhcmd = this.parseHandlerChains(reader, "http://java.sun.com/xml/ns/javaee", "urn:jboss:jbossws-jaxws-config:4.0", "post-handler-chains");
                        config.setPostHandlerChains(uhcmd.getHandlerChains());
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature")) {
                        config.setFeature(this.parseFeature(reader), true);
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "property")) {
                        this.parseProperty(reader, config);
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private void parseProperty(XMLStreamReader reader, CommonConfig config) throws XMLStreamException {
        String name = null;
        String value = null;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "property")) {
                        if (name == null) {
                            throw Messages.MESSAGES.couldNotGetPropertyName(this.getDescriptorForLogs());
                        }
                        config.setProperty(name, value);
                        return;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "property-name")) {
                        name = StAXUtils.elementAsString(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "property-value")) {
                        value = StAXUtils.elementAsString(reader);
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private Feature parseFeature(XMLStreamReader reader) throws XMLStreamException {
        Feature feature = null;
        block4: while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature")) {
                        if (feature == null) {
                            throw Messages.MESSAGES.couldNotGetFeatureName(this.getDescriptorForLogs());
                        }
                        return feature;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature-name")) {
                        feature = new Feature(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature-data")) {
                        Loggers.METADATA_LOGGER.elementNotSupported(new QName("urn:jboss:jbossws-jaxws-config:4.0", "feature-data").toString());
                        while (reader.hasNext()) {
                            reader.next();
                            if (!reader.isEndElement() || !StAXUtils.match(reader, "urn:jboss:jbossws-jaxws-config:4.0", "feature-data")) continue;
                            break block0;
                        }
                        continue block4;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    @Override
    protected String getDescriptorForLogs() {
        return "urn:jboss:jbossws-jaxws-config";
    }
}

