/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.AbstractHandlerChainsMetaDataParser;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.util.StAXUtils;

public class WebservicesFactory
extends AbstractHandlerChainsMetaDataParser {
    private final URL descriptorURL;

    public WebservicesFactory(URL descriptorURL) {
        this.descriptorURL = descriptorURL;
    }

    public WebservicesMetaData loadFromVFSRoot(UnifiedVirtualFile root) {
        WebservicesMetaData webservices = null;
        UnifiedVirtualFile wsdd = root.findChildFailSafe("META-INF/webservices.xml");
        if (null == wsdd) {
            wsdd = root.findChildFailSafe("WEB-INF/webservices.xml");
        }
        if (wsdd != null) {
            return this.load(wsdd.toURL());
        }
        return webservices;
    }

    public WebservicesMetaData load(URL wsddUrl) {
        InputStream is = null;
        try {
            is = wsddUrl.openStream();
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            WebservicesMetaData webservicesMetaData = this.parse(xmlr, wsddUrl);
            return webservicesMetaData;
        }
        catch (Exception e) {
            throw Messages.MESSAGES.failedToUnmarshall(e, wsddUrl);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public WebservicesMetaData parse(InputStream is) {
        return this.parse(is, null);
    }

    public WebservicesMetaData parse(InputStream is, URL descriptorURL) {
        try {
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            return this.parse(xmlr, descriptorURL);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public WebservicesMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return this.parse(reader, null);
    }

    private WebservicesMetaData parse(XMLStreamReader reader, URL descriptorURL) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        WebservicesMetaData metadata = null;
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match(reader, "http://java.sun.com/xml/ns/javaee", "webservices") || StAXUtils.match(reader, "http://java.sun.com/xml/ns/j2ee", "webservices") || StAXUtils.match(reader, "http://xmlns.jcp.org/xml/ns/javaee", "webservices")) {
                    String nsUri = reader.getNamespaceURI();
                    metadata = this.parseWebservices(reader, nsUri, descriptorURL);
                    break;
                }
                throw Messages.MESSAGES.unexpectedElement(descriptorURL != null ? descriptorURL.toString() : "webservices.xml", reader.getLocalName());
            }
        }
        return metadata;
    }

    private WebservicesMetaData parseWebservices(XMLStreamReader reader, String nsUri, URL descriptorURL) throws XMLStreamException {
        ArrayList<WebserviceDescriptionMetaData> wsdmds = new ArrayList<WebserviceDescriptionMetaData>(2);
        block4: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "webservices")) {
                        return new WebservicesMetaData(descriptorURL, wsdmds);
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description")) {
                        wsdmds.add(this.parseWebserviceDescription(reader, nsUri));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "description") || StAXUtils.match(reader, nsUri, "display-name")) {
                        this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "icon")) {
                        while (reader.hasNext() && (reader.nextTag() != 2 || !StAXUtils.match(reader, nsUri, "icon"))) {
                            reader.next();
                        }
                        continue block4;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    WebserviceDescriptionMetaData parseWebserviceDescription(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        String wsdlFile = null;
        String descriptionName = null;
        String jaxrpcMappingFile = null;
        ArrayList<PortComponentMetaData> pcms = new ArrayList<PortComponentMetaData>();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description")) {
                        return new WebserviceDescriptionMetaData(descriptionName, wsdlFile, jaxrpcMappingFile, pcms);
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description-name")) {
                        descriptionName = this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "wsdl-file")) {
                        wsdlFile = this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "jaxrpc-mapping-file")) {
                        jaxrpcMappingFile = this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "port-component")) {
                        pcms.add(this.parsePortComponent(reader, nsUri));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private PortComponentMetaData parsePortComponent(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        boolean respectBindingEnabled = false;
        PortComponentAddressing addressing = new PortComponentAddressing();
        PortComponentLinks links = new PortComponentLinks();
        String name = null;
        QName wsdlService = null;
        QName wsdlPort = null;
        boolean mtomEnabled = false;
        int mtomThreshold = 0;
        String protocolBinding = null;
        String serviceEndpointInterface = null;
        UnifiedHandlerChainsMetaData uhcs = null;
        ArrayList<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>(2);
        block4: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "port-component")) {
                        return new PortComponentMetaData(name, wsdlPort, serviceEndpointInterface, links.ejb, links.servlet, handlers, null, addressing.enabled, addressing.required, addressing.responses, mtomEnabled, mtomThreshold, respectBindingEnabled, wsdlService, protocolBinding, uhcs);
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "port-component-name")) {
                        name = this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "description") || StAXUtils.match(reader, nsUri, "display-name")) {
                        this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "icon")) {
                        while (reader.hasNext() && (reader.nextTag() != 2 || !StAXUtils.match(reader, nsUri, "icon"))) {
                            reader.next();
                        }
                        continue block4;
                    }
                    if (StAXUtils.match(reader, nsUri, "wsdl-service")) {
                        wsdlService = StAXUtils.elementAsQName(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "wsdl-port")) {
                        wsdlPort = StAXUtils.elementAsQName(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "enable-mtom")) {
                        mtomEnabled = StAXUtils.elementAsBoolean(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "mtom-threshold")) {
                        mtomThreshold = StAXUtils.elementAsInt(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "addressing")) {
                        this.parseAddressing(reader, nsUri, addressing);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "respect-binding")) {
                        respectBindingEnabled = this.parseRespectBinding(reader, nsUri);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "protocol-binding")) {
                        protocolBinding = this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "service-endpoint-interface")) {
                        serviceEndpointInterface = this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "service-impl-bean")) {
                        this.parseServiceImplBean(reader, nsUri, links);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "handler-chains")) {
                        uhcs = this.parseHandlerChains(reader, nsUri);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "handler")) {
                        handlers.add(this.parseHandler(reader, nsUri));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    protected String getElementText(XMLStreamReader reader) throws XMLStreamException {
        return StAXUtils.elementAsString(reader);
    }

    private void parseAddressing(XMLStreamReader reader, String nsUri, PortComponentAddressing pca) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "addressing")) {
                        return;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "enabled")) {
                        pca.enabled = StAXUtils.elementAsBoolean(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "required")) {
                        pca.required = StAXUtils.elementAsBoolean(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "responses")) {
                        pca.responses = this.getElementText(reader);
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private boolean parseRespectBinding(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        boolean respectBindingEnabled = false;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "respect-binding")) {
                        return respectBindingEnabled;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "enabled")) {
                        respectBindingEnabled = StAXUtils.elementAsBoolean(reader);
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private void parseServiceImplBean(XMLStreamReader reader, String nsUri, PortComponentLinks pcl) throws XMLStreamException {
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "service-impl-bean")) {
                        return;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "servlet-link")) {
                        pcl.servlet = this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "ejb-link")) {
                        pcl.ejb = this.getElementText(reader);
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    @Override
    protected String getDescriptorForLogs() {
        return this.descriptorURL != null ? this.descriptorURL.toString() : "webservices.xml";
    }

    public URL getDescriptorURL() {
        return this.descriptorURL;
    }

    private class PortComponentLinks {
        public String servlet;
        public String ejb;

        private PortComponentLinks() {
        }
    }

    private class PortComponentAddressing {
        public boolean enabled = false;
        public boolean required = false;
        public String responses = "ALL";

        private PortComponentAddressing() {
        }
    }
}

