/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.stack.metro;

// $Id: InvokerEJB3.java 6760 2008-04-29 20:32:37Z thomas.diesler@jboss.com $

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;

import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationHandler;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;

/**
 * An invoker for EJB3 endpoints
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 10-May-2007
 */
public class InvokerEJB3 extends Invoker
{
   private final InstanceResolver resolver;
   private WSWebServiceContext webServiceCtx;

   public InvokerEJB3(InstanceResolver resolver)
   {
      this.resolver = resolver;
   }

   @Override
   public void start(WSWebServiceContext webServiceCtx, WSEndpoint endpoint)
   {
      this.resolver.start(webServiceCtx, endpoint);
      this.webServiceCtx = webServiceCtx;
   }

   @Override
   public void dispose()
   {
      this.resolver.dispose();
   }

   @Override
   public <T> T invokeProvider(Packet p, T arg)
   {
      Object targetBean = this.resolver.resolve(p);
      return ((Provider<T>)targetBean).invoke(arg);
   }

   @Override
   public Object invoke(Packet p, Method m, Object... args)
   throws InvocationTargetException, IllegalAccessException
   {
      Endpoint endpoint = EndpointAssociation.getEndpoint();
      InvocationHandler invocationHandler = endpoint.getInvocationHandler();
      Invocation invocation = invocationHandler.createInvocation();
      invocation.getInvocationContext().addAttachment(MessageContext.class, this.webServiceCtx.getMessageContext());
      invocation.setJavaMethod(m);
      invocation.setArgs(args);

      Object retObj = null;
      try
      {
         invocationHandler.invoke(endpoint, invocation);
         retObj = invocation.getReturnValue();
      }
      catch (Exception ex)
      {
         handleException(ex);
      }

      return retObj;
   }

   private void handleException(Exception ex)
   throws InvocationTargetException, IllegalAccessException
   {
      if (ex instanceof InvocationTargetException)
         throw (InvocationTargetException)ex;

      if (ex instanceof IllegalAccessException)
         throw (IllegalAccessException)ex;

      throw new WebServiceException(ex);
   }
}