/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.metadata;

import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Module;
import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.ServerPipelineHook;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.ResourceLoader;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.stack.metro.DeploymentDescriptorParserExt;
import org.jboss.wsf.stack.metro.DeploymentDescriptorParserJBWS;
import org.jboss.wsf.stack.metro.MessageStreamAdapter;
import org.jboss.wsf.stack.metro.log.MessageLogPipelineHook;
import org.jboss.wsf.stack.metro.metadata.FakeServletContext;
import org.jboss.wsf.stack.metro.metadata.VFSResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeModelDeploymentAspect
extends DeploymentAspect {
    private static final Logger log = Logger.getLogger(RuntimeModelDeploymentAspect.class);
    protected static final String JAXWS_RI_RUNTIME = "/WEB-INF/sun-jaxws.xml";
    public static final String PARAM_SUN_JAXWS_URL = "jbossws-sun-jaxws-url";

    public void start(Deployment deployment, WSFRuntime runtime) {
        ClassLoader runtimeLoader = deployment.getRuntimeClassLoader();
        if (null == runtimeLoader) {
            throw new IllegalArgumentException("Null runtimeLoader");
        }
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(runtimeLoader);
            Object vfsRoot = null;
            vfsRoot = deployment instanceof ArchiveDeployment ? ((ArchiveDeployment)deployment).getRootFile() : new ResourceLoaderAdapter(runtimeLoader);
            VFSResourceLoader resourceLoader = new VFSResourceLoader((UnifiedVirtualFile)vfsRoot);
            JBossWSContainer container = new JBossWSContainer(resourceLoader);
            ServletAdapterList adapterList = new ServletAdapterList();
            DeploymentDescriptorParserExt<ServletAdapter> parser = this.createDeploymentDescriptorParser(runtimeLoader, container, resourceLoader, (DeploymentDescriptorParser.AdapterFactory<ServletAdapter>)adapterList);
            URL sunJaxWsXml = this.getDDUrlFromContext(deployment);
            List<ServletAdapter> adapters = parser.parse(sunJaxWsXml.toExternalForm(), sunJaxWsXml.openStream());
            block5: for (ServletAdapter adapter : adapters) {
                for (Endpoint ep : deployment.getService().getEndpoints()) {
                    boolean nameEquals = ep.getShortName().equals(adapter.getName());
                    boolean beanEquals = ep.getTargetBeanClass().equals(adapter.getEndpoint().getImplementationClass());
                    if (!nameEquals || !beanEquals) continue;
                    MessageStreamAdapter msgStreamAdapter = (MessageStreamAdapter)((Object)MessageStreamAdapter.FACTORY.createAdapter(adapter.getName(), null, adapter.getEndpoint()));
                    ep.addAttachment(MessageStreamAdapter.class, (Object)msgStreamAdapter);
                    ep.addAttachment(ServletAdapter.class, (Object)adapter);
                    continue block5;
                }
            }
        }
        catch (Throwable e) {
            throw new WebServiceException("Failed to build METRO runtime model", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    private URL getDDUrlFromContext(Deployment deployment) throws MalformedURLException {
        Map contextProperties = (Map)deployment.getProperty("org.jboss.ws.webapp.ContextParameterMap");
        return new URL((String)contextProperties.get(PARAM_SUN_JAXWS_URL));
    }

    protected DeploymentDescriptorParserExt<ServletAdapter> createDeploymentDescriptorParser(ClassLoader classLoader, JBossWSContainer container, ResourceLoader resourceLoader, DeploymentDescriptorParser.AdapterFactory<ServletAdapter> adapterList) throws MalformedURLException {
        return new DeploymentDescriptorParserJBWS<ServletAdapter>(classLoader, resourceLoader, container, adapterList);
    }

    protected URL getDDUrlFromResourceLoader(UnifiedVirtualFile vfsRoot) throws IOException {
        return vfsRoot.findChild(JAXWS_RI_RUNTIME).toURL();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JBossWSContainer
    extends Container {
        private ResourceLoader resourceLoader;
        private Module module = new Module(){
            private final List<BoundEndpoint> endpoints = new ArrayList<BoundEndpoint>();

            public List<BoundEndpoint> getBoundEndpoints() {
                return this.endpoints;
            }
        };

        JBossWSContainer(ResourceLoader loader) {
            this.resourceLoader = loader;
        }

        public <T> T getSPI(Class<T> spiType) {
            if (spiType == Module.class) {
                return spiType.cast(this.module);
            }
            if (spiType == ResourceInjector.class) {
                return (T)ResourceInjector.STANDALONE;
            }
            if (spiType == ServerPipelineHook.class) {
                return (T)((Object)new MessageLogPipelineHook());
            }
            if (spiType == ServletContext.class) {
                return (T)new FakeServletContext(this.resourceLoader);
            }
            log.warn((Object)("Unable to resolve SPI for type: " + spiType));
            return null;
        }
    }
}

