/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.metadata;

import com.sun.xml.ws.transport.http.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSResourceLoader
implements ResourceLoader {
    private static final Logger log = Logger.getLogger(VFSResourceLoader.class);
    UnifiedVirtualFile vfs;

    public VFSResourceLoader(UnifiedVirtualFile vfs) {
        this.vfs = vfs;
    }

    public URL getResource(String path) throws MalformedURLException {
        try {
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            return this.vfs.findChild(path).toURL();
        }
        catch (IOException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public URL getCatalogFile() throws MalformedURLException {
        URL resource = null;
        try {
            resource = this.getResource("/WEB-INF/jax-ws-catalog.xml");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return resource;
    }

    public Set<String> getResourcePaths(String path) {
        HashSet<String> resources = new HashSet<String>();
        try {
            URL rootUrl = this.getResource(path);
            if (rootUrl.getProtocol().equals("jar")) {
                log.warn((Object)"Cannot collect resourcePaths from EJB jar");
            } else {
                File root = new File(rootUrl.toURI());
                List<String> fileResources = VFSResourceLoader.getFileResources(root, path);
                resources.addAll(fileResources);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to read resource paths from '" + path + "': "), (Throwable)e);
        }
        return resources;
    }

    private static List<String> getFileResources(File root, String path) {
        File[] files;
        ArrayList<String> resources = new ArrayList<String>();
        if (root.exists() && (files = root.listFiles()) != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    resources.add(path + f.getName() + '/');
                    continue;
                }
                resources.add(path + f.getName());
            }
        }
        return resources;
    }

    private static List<String> getJARResources(JarFile jarFile, String path) {
        ArrayList<String> resources = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.matches(".*?\\.xml$") && !entryName.matches(".*?\\.wsdl$") && !entryName.matches(".*?\\.xsd$")) continue;
            resources.add(entryName);
        }
        return resources;
    }
}

