/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.stack.metro.metadata;

import com.sun.xml.ws.transport.http.ResourceLoader;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.logging.Logger;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.List;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.jar.JarEntry;

/**
 * @author Heiko.Braun@jboss.com
 */
public class VFSResourceLoader implements ResourceLoader
{

   private static final Logger log = Logger.getLogger(VFSResourceLoader.class);

   UnifiedVirtualFile vfs;

   public VFSResourceLoader(UnifiedVirtualFile vfs)
   {
      this.vfs = vfs;
   }

   public URL getResource(String path) throws MalformedURLException
   {
      try
      {
         if(path.startsWith("/"))
            path = path.substring(1, path.length());

         return vfs.findChild(path).toURL();
      }
      catch (IOException e)
      {
         throw new MalformedURLException(e.getMessage());
      }
   }

   public URL getCatalogFile() throws MalformedURLException
   {
      URL resource = null;
      try
      {
         resource = getResource("/WEB-INF/jax-ws-catalog.xml");
      }
      catch (MalformedURLException e)
      {
         // ingore
      }
      return resource;
   }

   public Set<String> getResourcePaths(String path)
   {
      Set<String> resources = new HashSet<String>();

      try
      {
         URL rootUrl = getResource(path);
         if(rootUrl.getProtocol().equals("jar"))
         {
            /*String urlString = rootUrl.toExternalForm();
            String jarRoot = urlString.substring(4, urlString.indexOf("jar!")+3);
           
            File jar = new File(jarRoot);
            assert jar.exists();
            JarFile jarFile = new JarFile(jar);
            
            List<String> jarResources = getJARResources(jarFile, path);

            resources.addAll(jarResources);*/
            log.warn("Cannot collect resourcePaths from EJB jar");
         }
         else
         {
            File root = new File(  rootUrl.toURI() );
            List<String> fileResources = getFileResources(root, path);
            resources.addAll(fileResources);
         }
      }
      catch (Exception e)
      {
         log.error("Failed to read resource paths from '"+path+"': ", e);
      }

      return resources;
   }

   private static List<String> getFileResources(File root, String path)
   {
      List<String> resources = new ArrayList<String>();

      if(root.exists())
      {
         File[] files = root.listFiles();
         if (files != null) {
            for( File f : files) {
               if(f.isDirectory()) {
                  resources.add(path+f.getName()+'/');
               } else {
                  resources.add(path+f.getName());
               }
            }
         }
      }
      return resources;
   }

   private static List<String> getJARResources(JarFile jarFile, String path) {
      List<String> resources = new ArrayList<String>();

      Enumeration entries = jarFile.entries();
      while (entries.hasMoreElements()) {
         JarEntry entry = (JarEntry) entries.nextElement();
         String entryName = entry.getName();

         if (entryName.matches(".*?\\.xml$")
           || entryName.matches(".*?\\.wsdl$")
           || entryName.matches(".*?\\.xsd$"))
         {
            resources.add(entryName);
         }
      }

      return resources;
   }
}
