/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro.metadata.sunjaxws;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.wsf.common.IOUtils;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.stack.metro.metadata.sunjaxws.DDEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDEndpoints {
    private List<DDEndpoint> endpoints = new ArrayList<DDEndpoint>();
    private File tmpFile;

    public List<DDEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public void addEndpoint(DDEndpoint ep) {
        this.endpoints.add(ep);
    }

    public URL createFileURL() {
        this.destroyFileURL();
        try {
            File tmpDir = IOUtils.createTempDirectory();
            this.tmpFile = File.createTempFile("jbossws-sun-jaxws", ".xml", tmpDir);
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(this.tmpFile));
            this.writeTo(writer);
            ((Writer)writer).close();
            return this.tmpFile.toURL();
        }
        catch (IOException ex) {
            throw new WSFDeploymentException((Throwable)ex);
        }
    }

    public void destroyFileURL() {
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write("<endpoints xmlns='http://java.sun.com/xml/ns/jax-ws/ri/runtime' version='2.0'>");
        for (DDEndpoint ep : this.endpoints) {
            ep.writeTo(writer);
        }
        writer.write("</endpoints>");
    }
}

