/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.metro;

import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.ResourceLoader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.stack.metro.DeploymentDescriptorParserExt;
import org.jboss.wsf.stack.metro.InvokerEJB3;
import org.jboss.wsf.stack.metro.InvokerJSE;
import org.jboss.wsf.stack.metro.WsgenWrapperGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentDescriptorParserJBWS<A>
extends DeploymentDescriptorParserExt<A> {
    private UnifiedVirtualFile archiveFile;

    public DeploymentDescriptorParserJBWS(ClassLoader cl, ResourceLoader loader, Container container, DeploymentDescriptorParser.AdapterFactory<A> adapterFactory) throws MalformedURLException {
        super(cl, loader, container, adapterFactory);
    }

    @Override
    protected Invoker createInvoker(Class<?> implClass) {
        InstanceResolver resolver = InstanceResolver.createDefault(implClass);
        Invoker invoker = implClass.isAnnotationPresent(Stateless.class) ? new InvokerEJB3(resolver) : new InvokerJSE(resolver);
        return invoker;
    }

    @Override
    protected void generateWrappers(Class<?> implementorClass, ClassLoader classLoader) {
        if (this.isWrapperGenerationEnabled() && this.isWrapperGenerationRequired(implementorClass, classLoader)) {
            WsgenWrapperGenerator wrapperGenerator = new WsgenWrapperGenerator(System.out);
            ClassLoader newClassLoader = wrapperGenerator.generate(implementorClass.getName(), classLoader, this.archiveFile.toURL());
            Thread.currentThread().setContextClassLoader(newClassLoader);
        }
    }

    private boolean isWrapperGenerationEnabled() {
        boolean noWrappersGeneration = Boolean.getBoolean("org.jboss.wsf.stack.metro.noWrappersGeneration");
        if (noWrappersGeneration) {
            Logger.getLogger(this.getClass()).debug((Object)"Wrapper generation disabled");
        }
        return !noWrappersGeneration;
    }

    private boolean isWrapperGenerationRequired(Class<?> endpoint, ClassLoader classLoader) {
        SOAPBinding soapBinding;
        WebService webServiceAnnotation = endpoint.getAnnotation(WebService.class);
        if (webServiceAnnotation == null) {
            return false;
        }
        String wsdlLocation = webServiceAnnotation.wsdlLocation();
        if (wsdlLocation != null && !"".equals(wsdlLocation)) {
            return false;
        }
        String endpointInterface = webServiceAnnotation.endpointInterface();
        if (endpointInterface == null || "".equalsIgnoreCase(endpointInterface)) {
            if (this.isFaultWrapperGenerationRequired(endpoint)) {
                return true;
            }
            soapBinding = endpoint.getAnnotation(SOAPBinding.class);
        } else {
            Class<?> sei;
            try {
                sei = Class.forName(endpointInterface, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new WebServiceException((Throwable)e);
            }
            if (this.isFaultWrapperGenerationRequired(sei)) {
                return true;
            }
            soapBinding = sei.getAnnotation(SOAPBinding.class);
        }
        if (soapBinding == null) {
            return true;
        }
        return !SOAPBinding.ParameterStyle.BARE.equals((Object)soapBinding.parameterStyle()) && !SOAPBinding.Style.RPC.equals((Object)soapBinding.style()) && !SOAPBinding.Use.ENCODED.equals((Object)soapBinding.use());
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFaultWrapperGenerationRequired(Class<?> clazz) {
        void var7_9;
        Method[] classMethods = clazz.getMethods();
        boolean webMethodAnnUsed = false;
        LinkedList<Method> webMethods = new LinkedList<Method>();
        Method[] arr$ = classMethods;
        int len$ = arr$.length;
        boolean bl = false;
        while (var7_9 < len$) {
            Method m = arr$[var7_9];
            if (m.getAnnotation(WebMethod.class) != null) {
                webMethods.add(m);
                webMethodAnnUsed = true;
            }
            ++var7_9;
        }
        List<Object> methods = webMethodAnnUsed ? webMethods : Arrays.asList(classMethods);
        for (Method method : methods) {
            Class<?>[] exceptionClasses;
            for (Class<?> exceptionClass : exceptionClasses = method.getExceptionTypes()) {
                if (exceptionClass.getAnnotation(WebFault.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void setArchiveFile(UnifiedVirtualFile file) {
        this.archiveFile = file;
    }
}

